/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteServiceSpecificCredentialRequest
extends IamRequest
implements ToCopyableBuilder<Builder, DeleteServiceSpecificCredentialRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(DeleteServiceSpecificCredentialRequest.getter(DeleteServiceSpecificCredentialRequest::userName)).setter(DeleteServiceSpecificCredentialRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceSpecificCredentialId").getter(DeleteServiceSpecificCredentialRequest.getter(DeleteServiceSpecificCredentialRequest::serviceSpecificCredentialId)).setter(DeleteServiceSpecificCredentialRequest.setter(Builder::serviceSpecificCredentialId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecificCredentialId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteServiceSpecificCredentialRequest.memberNameToFieldInitializer();
    private final String userName;
    private final String serviceSpecificCredentialId;

    private DeleteServiceSpecificCredentialRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String serviceSpecificCredentialId() {
        return this.serviceSpecificCredentialId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpecificCredentialId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceSpecificCredentialRequest)) {
            return false;
        }
        DeleteServiceSpecificCredentialRequest other = (DeleteServiceSpecificCredentialRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.serviceSpecificCredentialId(), other.serviceSpecificCredentialId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteServiceSpecificCredentialRequest").add("UserName", (Object)this.userName()).add("ServiceSpecificCredentialId", (Object)this.serviceSpecificCredentialId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "ServiceSpecificCredentialId": {
                return Optional.ofNullable(clazz.cast(this.serviceSpecificCredentialId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("ServiceSpecificCredentialId", SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteServiceSpecificCredentialRequest, T> g) {
        return obj -> g.apply((DeleteServiceSpecificCredentialRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String serviceSpecificCredentialId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceSpecificCredentialRequest model) {
            super(model);
            this.userName(model.userName);
            this.serviceSpecificCredentialId(model.serviceSpecificCredentialId);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getServiceSpecificCredentialId() {
            return this.serviceSpecificCredentialId;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteServiceSpecificCredentialRequest build() {
            return new DeleteServiceSpecificCredentialRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteServiceSpecificCredentialRequest> {
        public Builder userName(String var1);

        public Builder serviceSpecificCredentialId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

