/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.endpoints.IamEndpointParams;
import software.amazon.awssdk.services.iam.endpoints.IamEndpointProvider;
import software.amazon.awssdk.services.iam.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.iam.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.iam.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIamEndpointProvider
implements IamEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(IamEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultIamEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(IamEndpointParams params, String region) {
        RuleResult result = DefaultIamEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        return DefaultIamEndpointProvider.endpointRule6(params, region);
    }

    private static RuleResult endpointRule1(IamEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return DefaultIamEndpointProvider.endpointRule3(params);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(IamEndpointParams params) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(IamEndpointParams params, String region) {
        RuleResult result = DefaultIamEndpointProvider.endpointRule7(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule7(IamEndpointParams params, String region) {
        if (region != null) {
            return DefaultIamEndpointProvider.endpointRule8(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(IamEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            if ("aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.global.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-east-1").build())).build());
            }
            if ("aws".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam-fips.global.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-east-1").build())).build());
            }
            if ("aws-cn".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.global.api.amazonwebservices.com.cn")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("cn-north-1").build())).build());
            }
            if ("aws-cn".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.cn-north-1.amazonaws.com.cn")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("cn-north-1").build())).build());
            }
            if ("aws-us-gov".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-gov.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-gov-west-1").build())).build());
            }
            if ("aws-us-gov".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-gov.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-gov-west-1").build())).build());
            }
            if ("aws-us-gov".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-gov.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-gov-west-1").build())).build());
            }
            if ("aws-us-gov".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-gov.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-gov-west-1").build())).build());
            }
            if ("aws-iso".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-iso-east-1.c2s.ic.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-iso-east-1").build())).build());
            }
            if ("aws-iso".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam-fips.us-iso-east-1.c2s.ic.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-iso-east-1").build())).build());
            }
            if ("aws-iso-b".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-isob-east-1.sc2s.sgov.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-isob-east-1").build())).build());
            }
            if ("aws-iso-b".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam-fips.us-isob-east-1.sc2s.sgov.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-isob-east-1").build())).build());
            }
            if ("aws-iso-e".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.eu-isoe-west-1.cloud.adc-e.uk")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("eu-isoe-west-1").build())).build());
            }
            if ("aws-iso-f".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-isof-south-1.csp.hci.ic.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-isof-south-1").build())).build());
            }
            if ("aws-eusc".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.eusc-de-east-1.amazonaws.eu")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("eusc-de-east-1").build())).build());
            }
            RuleResult result = DefaultIamEndpointProvider.endpointRule24(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule28(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule32(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(IamEndpointParams params, RulePartition partitionResult) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIamEndpointProvider.endpointRule25(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule25(IamEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam-fips." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule28(IamEndpointParams params, RulePartition partitionResult) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIamEndpointProvider.endpointRule29(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule29(IamEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam-fips." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule32(IamEndpointParams params, RulePartition partitionResult) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIamEndpointProvider.endpointRule33(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule33(IamEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

