/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the most recent attempt to access an action within the service.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>GetServiceLastAccessedDetails</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrackedActionLastAccessed implements SdkPojo, Serializable,
        ToCopyableBuilder<TrackedActionLastAccessed.Builder, TrackedActionLastAccessed> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionName").getter(getter(TrackedActionLastAccessed::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()).build();

    private static final SdkField<String> LAST_ACCESSED_ENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastAccessedEntity").getter(getter(TrackedActionLastAccessed::lastAccessedEntity))
            .setter(setter(Builder::lastAccessedEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedEntity").build())
            .build();

    private static final SdkField<Instant> LAST_ACCESSED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAccessedTime").getter(getter(TrackedActionLastAccessed::lastAccessedTime))
            .setter(setter(Builder::lastAccessedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedTime").build()).build();

    private static final SdkField<String> LAST_ACCESSED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastAccessedRegion").getter(getter(TrackedActionLastAccessed::lastAccessedRegion))
            .setter(setter(Builder::lastAccessedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            LAST_ACCESSED_ENTITY_FIELD, LAST_ACCESSED_TIME_FIELD, LAST_ACCESSED_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionName;

    private final String lastAccessedEntity;

    private final Instant lastAccessedTime;

    private final String lastAccessedRegion;

    private TrackedActionLastAccessed(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.lastAccessedEntity = builder.lastAccessedEntity;
        this.lastAccessedTime = builder.lastAccessedTime;
        this.lastAccessedRegion = builder.lastAccessedRegion;
    }

    /**
     * <p>
     * The name of the tracked action to which access was attempted. Tracked actions are actions that report activity to
     * IAM.
     * </p>
     * 
     * @return The name of the tracked action to which access was attempted. Tracked actions are actions that report
     *         activity to IAM.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * Returns the value of the LastAccessedEntity property for this object.
     * 
     * @return The value of the LastAccessedEntity property for this object.
     */
    public final String lastAccessedEntity() {
        return lastAccessedEntity;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
     * authenticated entity most recently attempted to access the tracked service. Amazon Web Services does not report
     * unauthenticated requests.
     * </p>
     * <p>
     * This field is null if no IAM entities attempted to access the service within the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     * >tracking period</a>.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
     *         authenticated entity most recently attempted to access the tracked service. Amazon Web Services does not
     *         report unauthenticated requests.</p>
     *         <p>
     *         This field is null if no IAM entities attempted to access the service within the <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     *         >tracking period</a>.
     */
    public final Instant lastAccessedTime() {
        return lastAccessedTime;
    }

    /**
     * <p>
     * The Region from which the authenticated entity (user or role) last attempted to access the tracked action. Amazon
     * Web Services does not report unauthenticated requests.
     * </p>
     * <p>
     * This field is null if no IAM entities attempted to access the service within the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     * >tracking period</a>.
     * </p>
     * 
     * @return The Region from which the authenticated entity (user or role) last attempted to access the tracked
     *         action. Amazon Web Services does not report unauthenticated requests.</p>
     *         <p>
     *         This field is null if no IAM entities attempted to access the service within the <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     *         >tracking period</a>.
     */
    public final String lastAccessedRegion() {
        return lastAccessedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessedEntity());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessedRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackedActionLastAccessed)) {
            return false;
        }
        TrackedActionLastAccessed other = (TrackedActionLastAccessed) obj;
        return Objects.equals(actionName(), other.actionName())
                && Objects.equals(lastAccessedEntity(), other.lastAccessedEntity())
                && Objects.equals(lastAccessedTime(), other.lastAccessedTime())
                && Objects.equals(lastAccessedRegion(), other.lastAccessedRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrackedActionLastAccessed").add("ActionName", actionName())
                .add("LastAccessedEntity", lastAccessedEntity()).add("LastAccessedTime", lastAccessedTime())
                .add("LastAccessedRegion", lastAccessedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "LastAccessedEntity":
            return Optional.ofNullable(clazz.cast(lastAccessedEntity()));
        case "LastAccessedTime":
            return Optional.ofNullable(clazz.cast(lastAccessedTime()));
        case "LastAccessedRegion":
            return Optional.ofNullable(clazz.cast(lastAccessedRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrackedActionLastAccessed, T> g) {
        return obj -> g.apply((TrackedActionLastAccessed) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrackedActionLastAccessed> {
        /**
         * <p>
         * The name of the tracked action to which access was attempted. Tracked actions are actions that report
         * activity to IAM.
         * </p>
         * 
         * @param actionName
         *        The name of the tracked action to which access was attempted. Tracked actions are actions that report
         *        activity to IAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * Sets the value of the LastAccessedEntity property for this object.
         *
         * @param lastAccessedEntity
         *        The new value for the LastAccessedEntity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessedEntity(String lastAccessedEntity);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
         * authenticated entity most recently attempted to access the tracked service. Amazon Web Services does not
         * report unauthenticated requests.
         * </p>
         * <p>
         * This field is null if no IAM entities attempted to access the service within the <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         * >tracking period</a>.
         * </p>
         * 
         * @param lastAccessedTime
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
         *        authenticated entity most recently attempted to access the tracked service. Amazon Web Services does
         *        not report unauthenticated requests.</p>
         *        <p>
         *        This field is null if no IAM entities attempted to access the service within the <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         *        >tracking period</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessedTime(Instant lastAccessedTime);

        /**
         * <p>
         * The Region from which the authenticated entity (user or role) last attempted to access the tracked action.
         * Amazon Web Services does not report unauthenticated requests.
         * </p>
         * <p>
         * This field is null if no IAM entities attempted to access the service within the <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         * >tracking period</a>.
         * </p>
         * 
         * @param lastAccessedRegion
         *        The Region from which the authenticated entity (user or role) last attempted to access the tracked
         *        action. Amazon Web Services does not report unauthenticated requests.</p>
         *        <p>
         *        This field is null if no IAM entities attempted to access the service within the <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         *        >tracking period</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessedRegion(String lastAccessedRegion);
    }

    static final class BuilderImpl implements Builder {
        private String actionName;

        private String lastAccessedEntity;

        private Instant lastAccessedTime;

        private String lastAccessedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackedActionLastAccessed model) {
            actionName(model.actionName);
            lastAccessedEntity(model.lastAccessedEntity);
            lastAccessedTime(model.lastAccessedTime);
            lastAccessedRegion(model.lastAccessedRegion);
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getLastAccessedEntity() {
            return lastAccessedEntity;
        }

        public final void setLastAccessedEntity(String lastAccessedEntity) {
            this.lastAccessedEntity = lastAccessedEntity;
        }

        @Override
        public final Builder lastAccessedEntity(String lastAccessedEntity) {
            this.lastAccessedEntity = lastAccessedEntity;
            return this;
        }

        public final Instant getLastAccessedTime() {
            return lastAccessedTime;
        }

        public final void setLastAccessedTime(Instant lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        @Override
        public final Builder lastAccessedTime(Instant lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
            return this;
        }

        public final String getLastAccessedRegion() {
            return lastAccessedRegion;
        }

        public final void setLastAccessedRegion(String lastAccessedRegion) {
            this.lastAccessedRegion = lastAccessedRegion;
        }

        @Override
        public final Builder lastAccessedRegion(String lastAccessedRegion) {
            this.lastAccessedRegion = lastAccessedRegion;
            return this;
        }

        @Override
        public TrackedActionLastAccessed build() {
            return new TrackedActionLastAccessed(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
