/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListPolicyTagsIterable
implements SdkIterable<ListPolicyTagsResponse> {
    private final IamClient client;
    private final ListPolicyTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyTagsIterable(IamClient client, ListPolicyTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPolicyTagsResponseFetcher();
    }

    public Iterator<ListPolicyTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tag> tags() {
        Function<ListPolicyTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPolicyTagsResponseFetcher
    implements SyncPageFetcher<ListPolicyTagsResponse> {
        private ListPolicyTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyTagsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListPolicyTagsResponse nextPage(ListPolicyTagsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyTagsIterable.this.client.listPolicyTags(ListPolicyTagsIterable.this.firstRequest);
            }
            return ListPolicyTagsIterable.this.client.listPolicyTags((ListPolicyTagsRequest)((Object)ListPolicyTagsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

