/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an MFA device.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>ListMFADevices</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MFADevice implements SdkPojo, Serializable, ToCopyableBuilder<MFADevice.Builder, MFADevice> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(MFADevice::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(MFADevice::serialNumber)).setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()).build();

    private static final SdkField<Instant> ENABLE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EnableDate").getter(getter(MFADevice::enableDate)).setter(setter(Builder::enableDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            SERIAL_NUMBER_FIELD, ENABLE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final String serialNumber;

    private final Instant enableDate;

    private MFADevice(BuilderImpl builder) {
        this.userName = builder.userName;
        this.serialNumber = builder.serialNumber;
        this.enableDate = builder.enableDate;
    }

    /**
     * <p>
     * The user with whom the MFA device is associated.
     * </p>
     * 
     * @return The user with whom the MFA device is associated.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the
     * device ARN.
     * </p>
     * 
     * @return The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is
     *         the device ARN.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * The date when the MFA device was enabled for the user.
     * </p>
     * 
     * @return The date when the MFA device was enabled for the user.
     */
    public final Instant enableDate() {
        return enableDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(enableDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MFADevice)) {
            return false;
        }
        MFADevice other = (MFADevice) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(serialNumber(), other.serialNumber())
                && Objects.equals(enableDate(), other.enableDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MFADevice").add("UserName", userName()).add("SerialNumber", serialNumber())
                .add("EnableDate", enableDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "EnableDate":
            return Optional.ofNullable(clazz.cast(enableDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MFADevice, T> g) {
        return obj -> g.apply((MFADevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MFADevice> {
        /**
         * <p>
         * The user with whom the MFA device is associated.
         * </p>
         * 
         * @param userName
         *        The user with whom the MFA device is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the
         * device ARN.
         * </p>
         * 
         * @param serialNumber
         *        The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number
         *        is the device ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The date when the MFA device was enabled for the user.
         * </p>
         * 
         * @param enableDate
         *        The date when the MFA device was enabled for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDate(Instant enableDate);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private String serialNumber;

        private Instant enableDate;

        private BuilderImpl() {
        }

        private BuilderImpl(MFADevice model) {
            userName(model.userName);
            serialNumber(model.serialNumber);
            enableDate(model.enableDate);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final Instant getEnableDate() {
            return enableDate;
        }

        public final void setEnableDate(Instant enableDate) {
            this.enableDate = enableDate;
        }

        @Override
        public final Builder enableDate(Instant enableDate) {
            this.enableDate = enableDate;
            return this;
        }

        @Override
        public MFADevice build() {
            return new MFADevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
