/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;
import software.amazon.awssdk.services.iam.model.GetGroupResponse;
import software.amazon.awssdk.services.iam.model.User;

public class GetGroupIterable
implements SdkIterable<GetGroupResponse> {
    private final IamClient client;
    private final GetGroupRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetGroupIterable(IamClient client, GetGroupRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetGroupResponseFetcher();
    }

    public Iterator<GetGroupResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<User> users() {
        Function<GetGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetGroupResponseFetcher
    implements SyncPageFetcher<GetGroupResponse> {
        private GetGroupResponseFetcher() {
        }

        public boolean hasNextPage(GetGroupResponse previousPage) {
            return previousPage.isTruncated();
        }

        public GetGroupResponse nextPage(GetGroupResponse previousPage) {
            if (previousPage == null) {
                return GetGroupIterable.this.client.getGroup(GetGroupIterable.this.firstRequest);
            }
            return GetGroupIterable.this.client.getGroup((GetGroupRequest)((Object)GetGroupIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

