/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SortKeyType {
    SERVICE_NAMESPACE_ASCENDING("SERVICE_NAMESPACE_ASCENDING"),
    SERVICE_NAMESPACE_DESCENDING("SERVICE_NAMESPACE_DESCENDING"),
    LAST_AUTHENTICATED_TIME_ASCENDING("LAST_AUTHENTICATED_TIME_ASCENDING"),
    LAST_AUTHENTICATED_TIME_DESCENDING("LAST_AUTHENTICATED_TIME_DESCENDING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SortKeyType> VALUE_MAP;
    private final String value;

    private SortKeyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SortKeyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SortKeyType> knownValues() {
        EnumSet<SortKeyType> knownValues = EnumSet.allOf(SortKeyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SortKeyType.class, SortKeyType::toString);
    }
}

