/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicySourceType {
    USER("user"),
    GROUP("group"),
    ROLE("role"),
    AWS_MANAGED("aws-managed"),
    USER_MANAGED("user-managed"),
    RESOURCE("resource"),
    NONE("none"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicySourceType> VALUE_MAP;
    private final String value;

    private PolicySourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicySourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicySourceType> knownValues() {
        EnumSet<PolicySourceType> knownValues = EnumSet.allOf(PolicySourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicySourceType.class, PolicySourceType::toString);
    }
}

