/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.ListUserTagsRequest;
import software.amazon.awssdk.services.iam.model.ListUserTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListUserTagsPublisher
implements SdkPublisher<ListUserTagsResponse> {
    private final IamAsyncClient client;
    private final ListUserTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserTagsPublisher(IamAsyncClient client, ListUserTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserTagsPublisher(IamAsyncClient client, ListUserTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Tag> tags() {
        Function<ListUserTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUserTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUserTagsResponseFetcher
    implements AsyncPageFetcher<ListUserTagsResponse> {
        private ListUserTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserTagsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListUserTagsResponse> nextPage(ListUserTagsResponse previousPage) {
            if (previousPage == null) {
                return ListUserTagsPublisher.this.client.listUserTags(ListUserTagsPublisher.this.firstRequest);
            }
            return ListUserTagsPublisher.this.client.listUserTags((ListUserTagsRequest)((Object)ListUserTagsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

