/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReportStateType {
    STARTED("STARTED"),
    INPROGRESS("INPROGRESS"),
    COMPLETE("COMPLETE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReportStateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReportStateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReportStateType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReportStateType> knownValues() {
        return Stream.of(ReportStateType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

