/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveClientIdFromOpenIdConnectProviderRequest
extends IamRequest
implements ToCopyableBuilder<Builder, RemoveClientIdFromOpenIdConnectProviderRequest> {
    private static final SdkField<String> OPEN_ID_CONNECT_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpenIDConnectProviderArn").getter(RemoveClientIdFromOpenIdConnectProviderRequest.getter(RemoveClientIdFromOpenIdConnectProviderRequest::openIDConnectProviderArn)).setter(RemoveClientIdFromOpenIdConnectProviderRequest.setter(Builder::openIDConnectProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIDConnectProviderArn").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientID").getter(RemoveClientIdFromOpenIdConnectProviderRequest.getter(RemoveClientIdFromOpenIdConnectProviderRequest::clientID)).setter(RemoveClientIdFromOpenIdConnectProviderRequest.setter(Builder::clientID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_ID_CONNECT_PROVIDER_ARN_FIELD, CLIENT_ID_FIELD));
    private final String openIDConnectProviderArn;
    private final String clientID;

    private RemoveClientIdFromOpenIdConnectProviderRequest(BuilderImpl builder) {
        super(builder);
        this.openIDConnectProviderArn = builder.openIDConnectProviderArn;
        this.clientID = builder.clientID;
    }

    public final String openIDConnectProviderArn() {
        return this.openIDConnectProviderArn;
    }

    public final String clientID() {
        return this.clientID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveClientIdFromOpenIdConnectProviderRequest)) {
            return false;
        }
        RemoveClientIdFromOpenIdConnectProviderRequest other = (RemoveClientIdFromOpenIdConnectProviderRequest)((Object)obj);
        return Objects.equals(this.openIDConnectProviderArn(), other.openIDConnectProviderArn()) && Objects.equals(this.clientID(), other.clientID());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveClientIdFromOpenIdConnectProviderRequest").add("OpenIDConnectProviderArn", (Object)this.openIDConnectProviderArn()).add("ClientID", (Object)this.clientID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpenIDConnectProviderArn": {
                return Optional.ofNullable(clazz.cast(this.openIDConnectProviderArn()));
            }
            case "ClientID": {
                return Optional.ofNullable(clazz.cast(this.clientID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveClientIdFromOpenIdConnectProviderRequest, T> g) {
        return obj -> g.apply((RemoveClientIdFromOpenIdConnectProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String openIDConnectProviderArn;
        private String clientID;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveClientIdFromOpenIdConnectProviderRequest model) {
            super(model);
            this.openIDConnectProviderArn(model.openIDConnectProviderArn);
            this.clientID(model.clientID);
        }

        public final String getOpenIDConnectProviderArn() {
            return this.openIDConnectProviderArn;
        }

        @Override
        public final Builder openIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
            return this;
        }

        public final void setOpenIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
        }

        public final String getClientID() {
            return this.clientID;
        }

        @Override
        public final Builder clientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        public final void setClientID(String clientID) {
            this.clientID = clientID;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveClientIdFromOpenIdConnectProviderRequest build() {
            return new RemoveClientIdFromOpenIdConnectProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveClientIdFromOpenIdConnectProviderRequest> {
        public Builder openIDConnectProviderArn(String var1);

        public Builder clientID(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

