/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.healthlake.HealthLakeClient;
import software.amazon.awssdk.services.healthlake.internal.UserAgentUtils;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse;

public class ListFHIRDatastoresIterable
implements SdkIterable<ListFhirDatastoresResponse> {
    private final HealthLakeClient client;
    private final ListFhirDatastoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFHIRDatastoresIterable(HealthLakeClient client, ListFhirDatastoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFhirDatastoresResponseFetcher();
    }

    public Iterator<ListFhirDatastoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFhirDatastoresResponseFetcher
    implements SyncPageFetcher<ListFhirDatastoresResponse> {
        private ListFhirDatastoresResponseFetcher() {
        }

        public boolean hasNextPage(ListFhirDatastoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFhirDatastoresResponse nextPage(ListFhirDatastoresResponse previousPage) {
            if (previousPage == null) {
                return ListFHIRDatastoresIterable.this.client.listFHIRDatastores(ListFHIRDatastoresIterable.this.firstRequest);
            }
            return ListFHIRDatastoresIterable.this.client.listFHIRDatastores((ListFhirDatastoresRequest)((Object)ListFHIRDatastoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

