/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.healthlake.model.DatastoreStatus;
import software.amazon.awssdk.services.healthlake.model.HealthLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFhirDatastoreResponse
extends HealthLakeResponse
implements ToCopyableBuilder<Builder, DeleteFhirDatastoreResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreId").getter(DeleteFhirDatastoreResponse.getter(DeleteFhirDatastoreResponse::datastoreId)).setter(DeleteFhirDatastoreResponse.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreId").build()}).build();
    private static final SdkField<String> DATASTORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreArn").getter(DeleteFhirDatastoreResponse.getter(DeleteFhirDatastoreResponse::datastoreArn)).setter(DeleteFhirDatastoreResponse.setter(Builder::datastoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreArn").build()}).build();
    private static final SdkField<String> DATASTORE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreStatus").getter(DeleteFhirDatastoreResponse.getter(DeleteFhirDatastoreResponse::datastoreStatusAsString)).setter(DeleteFhirDatastoreResponse.setter(Builder::datastoreStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreStatus").build()}).build();
    private static final SdkField<String> DATASTORE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreEndpoint").getter(DeleteFhirDatastoreResponse.getter(DeleteFhirDatastoreResponse::datastoreEndpoint)).setter(DeleteFhirDatastoreResponse.setter(Builder::datastoreEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, DATASTORE_ARN_FIELD, DATASTORE_STATUS_FIELD, DATASTORE_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteFhirDatastoreResponse.memberNameToFieldInitializer();
    private final String datastoreId;
    private final String datastoreArn;
    private final String datastoreStatus;
    private final String datastoreEndpoint;

    private DeleteFhirDatastoreResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.datastoreArn = builder.datastoreArn;
        this.datastoreStatus = builder.datastoreStatus;
        this.datastoreEndpoint = builder.datastoreEndpoint;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final String datastoreArn() {
        return this.datastoreArn;
    }

    public final DatastoreStatus datastoreStatus() {
        return DatastoreStatus.fromValue(this.datastoreStatus);
    }

    public final String datastoreStatusAsString() {
        return this.datastoreStatus;
    }

    public final String datastoreEndpoint() {
        return this.datastoreEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFhirDatastoreResponse)) {
            return false;
        }
        DeleteFhirDatastoreResponse other = (DeleteFhirDatastoreResponse)((Object)obj);
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.datastoreArn(), other.datastoreArn()) && Objects.equals(this.datastoreStatusAsString(), other.datastoreStatusAsString()) && Objects.equals(this.datastoreEndpoint(), other.datastoreEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFhirDatastoreResponse").add("DatastoreId", (Object)this.datastoreId()).add("DatastoreArn", (Object)this.datastoreArn()).add("DatastoreStatus", (Object)this.datastoreStatusAsString()).add("DatastoreEndpoint", (Object)this.datastoreEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "DatastoreArn": {
                return Optional.ofNullable(clazz.cast(this.datastoreArn()));
            }
            case "DatastoreStatus": {
                return Optional.ofNullable(clazz.cast(this.datastoreStatusAsString()));
            }
            case "DatastoreEndpoint": {
                return Optional.ofNullable(clazz.cast(this.datastoreEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DatastoreId", DATASTORE_ID_FIELD);
        map.put("DatastoreArn", DATASTORE_ARN_FIELD);
        map.put("DatastoreStatus", DATASTORE_STATUS_FIELD);
        map.put("DatastoreEndpoint", DATASTORE_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFhirDatastoreResponse, T> g) {
        return obj -> g.apply((DeleteFhirDatastoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthLakeResponse.BuilderImpl
    implements Builder {
        private String datastoreId;
        private String datastoreArn;
        private String datastoreStatus;
        private String datastoreEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFhirDatastoreResponse model) {
            super(model);
            this.datastoreId(model.datastoreId);
            this.datastoreArn(model.datastoreArn);
            this.datastoreStatus(model.datastoreStatus);
            this.datastoreEndpoint(model.datastoreEndpoint);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getDatastoreArn() {
            return this.datastoreArn;
        }

        public final void setDatastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
        }

        @Override
        public final Builder datastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
            return this;
        }

        public final String getDatastoreStatus() {
            return this.datastoreStatus;
        }

        public final void setDatastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
        }

        @Override
        public final Builder datastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
            return this;
        }

        @Override
        public final Builder datastoreStatus(DatastoreStatus datastoreStatus) {
            this.datastoreStatus(datastoreStatus == null ? null : datastoreStatus.toString());
            return this;
        }

        public final String getDatastoreEndpoint() {
            return this.datastoreEndpoint;
        }

        public final void setDatastoreEndpoint(String datastoreEndpoint) {
            this.datastoreEndpoint = datastoreEndpoint;
        }

        @Override
        public final Builder datastoreEndpoint(String datastoreEndpoint) {
            this.datastoreEndpoint = datastoreEndpoint;
            return this;
        }

        @Override
        public DeleteFhirDatastoreResponse build() {
            return new DeleteFhirDatastoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends HealthLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFhirDatastoreResponse> {
        public Builder datastoreId(String var1);

        public Builder datastoreArn(String var1);

        public Builder datastoreStatus(String var1);

        public Builder datastoreStatus(DatastoreStatus var1);

        public Builder datastoreEndpoint(String var1);
    }
}

