/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PreloadDataType {
    SYNTHEA("SYNTHEA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PreloadDataType> VALUE_MAP;
    private final String value;

    private PreloadDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PreloadDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PreloadDataType> knownValues() {
        EnumSet<PreloadDataType> knownValues = EnumSet.allOf(PreloadDataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PreloadDataType.class, PreloadDataType::toString);
    }
}

