/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.healthlake.model.CmkType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KmsEncryptionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KmsEncryptionConfig> {
    private static final SdkField<String> CMK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CmkType").getter(KmsEncryptionConfig.getter(KmsEncryptionConfig::cmkTypeAsString)).setter(KmsEncryptionConfig.setter(Builder::cmkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CmkType").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(KmsEncryptionConfig.getter(KmsEncryptionConfig::kmsKeyId)).setter(KmsEncryptionConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CMK_TYPE_FIELD, KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KmsEncryptionConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cmkType;
    private final String kmsKeyId;

    private KmsEncryptionConfig(BuilderImpl builder) {
        this.cmkType = builder.cmkType;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final CmkType cmkType() {
        return CmkType.fromValue(this.cmkType);
    }

    public final String cmkTypeAsString() {
        return this.cmkType;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cmkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsEncryptionConfig)) {
            return false;
        }
        KmsEncryptionConfig other = (KmsEncryptionConfig)obj;
        return Objects.equals(this.cmkTypeAsString(), other.cmkTypeAsString()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"KmsEncryptionConfig").add("CmkType", (Object)this.cmkTypeAsString()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CmkType": {
                return Optional.ofNullable(clazz.cast(this.cmkTypeAsString()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CmkType", CMK_TYPE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KmsEncryptionConfig, T> g) {
        return obj -> g.apply((KmsEncryptionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cmkType;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(KmsEncryptionConfig model) {
            this.cmkType(model.cmkType);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getCmkType() {
            return this.cmkType;
        }

        public final void setCmkType(String cmkType) {
            this.cmkType = cmkType;
        }

        @Override
        public final Builder cmkType(String cmkType) {
            this.cmkType = cmkType;
            return this;
        }

        @Override
        public final Builder cmkType(CmkType cmkType) {
            this.cmkType(cmkType == null ? null : cmkType.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public KmsEncryptionConfig build() {
            return new KmsEncryptionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KmsEncryptionConfig> {
        public Builder cmkType(String var1);

        public Builder cmkType(CmkType var1);

        public Builder kmsKeyId(String var1);
    }
}

