/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.healthlake.DefaultHealthLakeAsyncClientBuilder;
import software.amazon.awssdk.services.healthlake.HealthLakeAsyncClientBuilder;
import software.amazon.awssdk.services.healthlake.HealthLakeServiceClientConfiguration;
import software.amazon.awssdk.services.healthlake.model.CreateFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.CreateFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DeleteFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.DeleteFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobResponse;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse;
import software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsResponse;
import software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsResponse;
import software.amazon.awssdk.services.healthlake.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.healthlake.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.healthlake.model.StartFhirExportJobRequest;
import software.amazon.awssdk.services.healthlake.model.StartFhirExportJobResponse;
import software.amazon.awssdk.services.healthlake.model.StartFhirImportJobRequest;
import software.amazon.awssdk.services.healthlake.model.StartFhirImportJobResponse;
import software.amazon.awssdk.services.healthlake.model.TagResourceRequest;
import software.amazon.awssdk.services.healthlake.model.TagResourceResponse;
import software.amazon.awssdk.services.healthlake.model.UntagResourceRequest;
import software.amazon.awssdk.services.healthlake.model.UntagResourceResponse;
import software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher;
import software.amazon.awssdk.services.healthlake.paginators.ListFHIRExportJobsPublisher;
import software.amazon.awssdk.services.healthlake.paginators.ListFHIRImportJobsPublisher;

@SdkPublicApi
@ThreadSafe
public interface HealthLakeAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "healthlake";
    public static final String SERVICE_METADATA_ID = "healthlake";

    default public CompletableFuture<CreateFhirDatastoreResponse> createFHIRDatastore(CreateFhirDatastoreRequest createFhirDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateFhirDatastoreResponse> createFHIRDatastore(Consumer<CreateFhirDatastoreRequest.Builder> createFhirDatastoreRequest) {
        return this.createFHIRDatastore((CreateFhirDatastoreRequest)((Object)((CreateFhirDatastoreRequest.Builder)CreateFhirDatastoreRequest.builder().applyMutation(createFhirDatastoreRequest)).build()));
    }

    default public CompletableFuture<DeleteFhirDatastoreResponse> deleteFHIRDatastore(DeleteFhirDatastoreRequest deleteFhirDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteFhirDatastoreResponse> deleteFHIRDatastore(Consumer<DeleteFhirDatastoreRequest.Builder> deleteFhirDatastoreRequest) {
        return this.deleteFHIRDatastore((DeleteFhirDatastoreRequest)((Object)((DeleteFhirDatastoreRequest.Builder)DeleteFhirDatastoreRequest.builder().applyMutation(deleteFhirDatastoreRequest)).build()));
    }

    default public CompletableFuture<DescribeFhirDatastoreResponse> describeFHIRDatastore(DescribeFhirDatastoreRequest describeFhirDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeFhirDatastoreResponse> describeFHIRDatastore(Consumer<DescribeFhirDatastoreRequest.Builder> describeFhirDatastoreRequest) {
        return this.describeFHIRDatastore((DescribeFhirDatastoreRequest)((Object)((DescribeFhirDatastoreRequest.Builder)DescribeFhirDatastoreRequest.builder().applyMutation(describeFhirDatastoreRequest)).build()));
    }

    default public CompletableFuture<DescribeFhirExportJobResponse> describeFHIRExportJob(DescribeFhirExportJobRequest describeFhirExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeFhirExportJobResponse> describeFHIRExportJob(Consumer<DescribeFhirExportJobRequest.Builder> describeFhirExportJobRequest) {
        return this.describeFHIRExportJob((DescribeFhirExportJobRequest)((Object)((DescribeFhirExportJobRequest.Builder)DescribeFhirExportJobRequest.builder().applyMutation(describeFhirExportJobRequest)).build()));
    }

    default public CompletableFuture<DescribeFhirImportJobResponse> describeFHIRImportJob(DescribeFhirImportJobRequest describeFhirImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeFhirImportJobResponse> describeFHIRImportJob(Consumer<DescribeFhirImportJobRequest.Builder> describeFhirImportJobRequest) {
        return this.describeFHIRImportJob((DescribeFhirImportJobRequest)((Object)((DescribeFhirImportJobRequest.Builder)DescribeFhirImportJobRequest.builder().applyMutation(describeFhirImportJobRequest)).build()));
    }

    default public CompletableFuture<ListFhirDatastoresResponse> listFHIRDatastores(ListFhirDatastoresRequest listFhirDatastoresRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListFhirDatastoresResponse> listFHIRDatastores(Consumer<ListFhirDatastoresRequest.Builder> listFhirDatastoresRequest) {
        return this.listFHIRDatastores((ListFhirDatastoresRequest)((Object)((ListFhirDatastoresRequest.Builder)ListFhirDatastoresRequest.builder().applyMutation(listFhirDatastoresRequest)).build()));
    }

    default public ListFHIRDatastoresPublisher listFHIRDatastoresPaginator(ListFhirDatastoresRequest listFhirDatastoresRequest) {
        return new ListFHIRDatastoresPublisher(this, listFhirDatastoresRequest);
    }

    default public ListFHIRDatastoresPublisher listFHIRDatastoresPaginator(Consumer<ListFhirDatastoresRequest.Builder> listFhirDatastoresRequest) {
        return this.listFHIRDatastoresPaginator((ListFhirDatastoresRequest)((Object)((ListFhirDatastoresRequest.Builder)ListFhirDatastoresRequest.builder().applyMutation(listFhirDatastoresRequest)).build()));
    }

    default public CompletableFuture<ListFhirExportJobsResponse> listFHIRExportJobs(ListFhirExportJobsRequest listFhirExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListFhirExportJobsResponse> listFHIRExportJobs(Consumer<ListFhirExportJobsRequest.Builder> listFhirExportJobsRequest) {
        return this.listFHIRExportJobs((ListFhirExportJobsRequest)((Object)((ListFhirExportJobsRequest.Builder)ListFhirExportJobsRequest.builder().applyMutation(listFhirExportJobsRequest)).build()));
    }

    default public ListFHIRExportJobsPublisher listFHIRExportJobsPaginator(ListFhirExportJobsRequest listFhirExportJobsRequest) {
        return new ListFHIRExportJobsPublisher(this, listFhirExportJobsRequest);
    }

    default public ListFHIRExportJobsPublisher listFHIRExportJobsPaginator(Consumer<ListFhirExportJobsRequest.Builder> listFhirExportJobsRequest) {
        return this.listFHIRExportJobsPaginator((ListFhirExportJobsRequest)((Object)((ListFhirExportJobsRequest.Builder)ListFhirExportJobsRequest.builder().applyMutation(listFhirExportJobsRequest)).build()));
    }

    default public CompletableFuture<ListFhirImportJobsResponse> listFHIRImportJobs(ListFhirImportJobsRequest listFhirImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListFhirImportJobsResponse> listFHIRImportJobs(Consumer<ListFhirImportJobsRequest.Builder> listFhirImportJobsRequest) {
        return this.listFHIRImportJobs((ListFhirImportJobsRequest)((Object)((ListFhirImportJobsRequest.Builder)ListFhirImportJobsRequest.builder().applyMutation(listFhirImportJobsRequest)).build()));
    }

    default public ListFHIRImportJobsPublisher listFHIRImportJobsPaginator(ListFhirImportJobsRequest listFhirImportJobsRequest) {
        return new ListFHIRImportJobsPublisher(this, listFhirImportJobsRequest);
    }

    default public ListFHIRImportJobsPublisher listFHIRImportJobsPaginator(Consumer<ListFhirImportJobsRequest.Builder> listFhirImportJobsRequest) {
        return this.listFHIRImportJobsPaginator((ListFhirImportJobsRequest)((Object)((ListFhirImportJobsRequest.Builder)ListFhirImportJobsRequest.builder().applyMutation(listFhirImportJobsRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<StartFhirExportJobResponse> startFHIRExportJob(StartFhirExportJobRequest startFhirExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartFhirExportJobResponse> startFHIRExportJob(Consumer<StartFhirExportJobRequest.Builder> startFhirExportJobRequest) {
        return this.startFHIRExportJob((StartFhirExportJobRequest)((Object)((StartFhirExportJobRequest.Builder)StartFhirExportJobRequest.builder().applyMutation(startFhirExportJobRequest)).build()));
    }

    default public CompletableFuture<StartFhirImportJobResponse> startFHIRImportJob(StartFhirImportJobRequest startFhirImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartFhirImportJobResponse> startFHIRImportJob(Consumer<StartFhirImportJobRequest.Builder> startFhirImportJobRequest) {
        return this.startFHIRImportJob((StartFhirImportJobRequest)((Object)((StartFhirImportJobRequest.Builder)StartFhirImportJobRequest.builder().applyMutation(startFhirImportJobRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public HealthLakeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static HealthLakeAsyncClient create() {
        return (HealthLakeAsyncClient)HealthLakeAsyncClient.builder().build();
    }

    public static HealthLakeAsyncClientBuilder builder() {
        return new DefaultHealthLakeAsyncClientBuilder();
    }
}

