/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.healthlake.HealthLakeAsyncClient;
import software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsResponse;

public class ListFHIRExportJobsPublisher
implements SdkPublisher<ListFhirExportJobsResponse> {
    private final HealthLakeAsyncClient client;
    private final ListFhirExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFHIRExportJobsPublisher(HealthLakeAsyncClient client, ListFhirExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFHIRExportJobsPublisher(HealthLakeAsyncClient client, ListFhirExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFhirExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFhirExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFhirExportJobsResponseFetcher
    implements AsyncPageFetcher<ListFhirExportJobsResponse> {
        private ListFhirExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListFhirExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFhirExportJobsResponse> nextPage(ListFhirExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListFHIRExportJobsPublisher.this.client.listFHIRExportJobs(ListFHIRExportJobsPublisher.this.firstRequest);
            }
            return ListFHIRExportJobsPublisher.this.client.listFHIRExportJobs((ListFhirExportJobsRequest)((Object)ListFHIRExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

