/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFhirDatastoreResponse extends HealthLakeResponse implements
        ToCopyableBuilder<CreateFhirDatastoreResponse.Builder, CreateFhirDatastoreResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreId").getter(getter(CreateFhirDatastoreResponse::datastoreId))
            .setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreId").build()).build();

    private static final SdkField<String> DATASTORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreArn").getter(getter(CreateFhirDatastoreResponse::datastoreArn))
            .setter(setter(Builder::datastoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreArn").build()).build();

    private static final SdkField<String> DATASTORE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreStatus").getter(getter(CreateFhirDatastoreResponse::datastoreStatusAsString))
            .setter(setter(Builder::datastoreStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreStatus").build()).build();

    private static final SdkField<String> DATASTORE_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreEndpoint").getter(getter(CreateFhirDatastoreResponse::datastoreEndpoint))
            .setter(setter(Builder::datastoreEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            DATASTORE_ARN_FIELD, DATASTORE_STATUS_FIELD, DATASTORE_ENDPOINT_FIELD));

    private final String datastoreId;

    private final String datastoreArn;

    private final String datastoreStatus;

    private final String datastoreEndpoint;

    private CreateFhirDatastoreResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.datastoreArn = builder.datastoreArn;
        this.datastoreStatus = builder.datastoreStatus;
        this.datastoreEndpoint = builder.datastoreEndpoint;
    }

    /**
     * <p>
     * The AWS-generated Data Store id. This id is in the output from the initial Data Store creation call.
     * </p>
     * 
     * @return The AWS-generated Data Store id. This id is in the output from the initial Data Store creation call.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The datastore ARN is generated during the creation of the Data Store and can be found in the output from the
     * initial Data Store creation call.
     * </p>
     * 
     * @return The datastore ARN is generated during the creation of the Data Store and can be found in the output from
     *         the initial Data Store creation call.
     */
    public final String datastoreArn() {
        return datastoreArn;
    }

    /**
     * <p>
     * The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datastoreStatus}
     * will return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #datastoreStatusAsString}.
     * </p>
     * 
     * @return The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
     * @see DatastoreStatus
     */
    public final DatastoreStatus datastoreStatus() {
        return DatastoreStatus.fromValue(datastoreStatus);
    }

    /**
     * <p>
     * The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datastoreStatus}
     * will return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #datastoreStatusAsString}.
     * </p>
     * 
     * @return The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
     * @see DatastoreStatus
     */
    public final String datastoreStatusAsString() {
        return datastoreStatus;
    }

    /**
     * <p>
     * The AWS endpoint for the created Data Store. For preview, only US-east-1 endpoints are supported.
     * </p>
     * 
     * @return The AWS endpoint for the created Data Store. For preview, only US-east-1 endpoints are supported.
     */
    public final String datastoreEndpoint() {
        return datastoreEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFhirDatastoreResponse)) {
            return false;
        }
        CreateFhirDatastoreResponse other = (CreateFhirDatastoreResponse) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(datastoreArn(), other.datastoreArn())
                && Objects.equals(datastoreStatusAsString(), other.datastoreStatusAsString())
                && Objects.equals(datastoreEndpoint(), other.datastoreEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFhirDatastoreResponse").add("DatastoreId", datastoreId())
                .add("DatastoreArn", datastoreArn()).add("DatastoreStatus", datastoreStatusAsString())
                .add("DatastoreEndpoint", datastoreEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "DatastoreArn":
            return Optional.ofNullable(clazz.cast(datastoreArn()));
        case "DatastoreStatus":
            return Optional.ofNullable(clazz.cast(datastoreStatusAsString()));
        case "DatastoreEndpoint":
            return Optional.ofNullable(clazz.cast(datastoreEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFhirDatastoreResponse, T> g) {
        return obj -> g.apply((CreateFhirDatastoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthLakeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFhirDatastoreResponse> {
        /**
         * <p>
         * The AWS-generated Data Store id. This id is in the output from the initial Data Store creation call.
         * </p>
         * 
         * @param datastoreId
         *        The AWS-generated Data Store id. This id is in the output from the initial Data Store creation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The datastore ARN is generated during the creation of the Data Store and can be found in the output from the
         * initial Data Store creation call.
         * </p>
         * 
         * @param datastoreArn
         *        The datastore ARN is generated during the creation of the Data Store and can be found in the output
         *        from the initial Data Store creation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreArn(String datastoreArn);

        /**
         * <p>
         * The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
         * </p>
         * 
         * @param datastoreStatus
         *        The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder datastoreStatus(String datastoreStatus);

        /**
         * <p>
         * The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
         * </p>
         * 
         * @param datastoreStatus
         *        The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder datastoreStatus(DatastoreStatus datastoreStatus);

        /**
         * <p>
         * The AWS endpoint for the created Data Store. For preview, only US-east-1 endpoints are supported.
         * </p>
         * 
         * @param datastoreEndpoint
         *        The AWS endpoint for the created Data Store. For preview, only US-east-1 endpoints are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreEndpoint(String datastoreEndpoint);
    }

    static final class BuilderImpl extends HealthLakeResponse.BuilderImpl implements Builder {
        private String datastoreId;

        private String datastoreArn;

        private String datastoreStatus;

        private String datastoreEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFhirDatastoreResponse model) {
            super(model);
            datastoreId(model.datastoreId);
            datastoreArn(model.datastoreArn);
            datastoreStatus(model.datastoreStatus);
            datastoreEndpoint(model.datastoreEndpoint);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        @Transient
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getDatastoreArn() {
            return datastoreArn;
        }

        public final void setDatastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
        }

        @Override
        @Transient
        public final Builder datastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
            return this;
        }

        public final String getDatastoreStatus() {
            return datastoreStatus;
        }

        public final void setDatastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
        }

        @Override
        @Transient
        public final Builder datastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder datastoreStatus(DatastoreStatus datastoreStatus) {
            this.datastoreStatus(datastoreStatus == null ? null : datastoreStatus.toString());
            return this;
        }

        public final String getDatastoreEndpoint() {
            return datastoreEndpoint;
        }

        public final void setDatastoreEndpoint(String datastoreEndpoint) {
            this.datastoreEndpoint = datastoreEndpoint;
        }

        @Override
        @Transient
        public final Builder datastoreEndpoint(String datastoreEndpoint) {
            this.datastoreEndpoint = datastoreEndpoint;
            return this;
        }

        @Override
        public CreateFhirDatastoreResponse build() {
            return new CreateFhirDatastoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
