/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.health.HealthAsyncClient;
import software.amazon.awssdk.services.health.internal.UserAgentUtils;
import software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse;

public class DescribeAffectedAccountsForOrganizationPublisher
implements SdkPublisher<DescribeAffectedAccountsForOrganizationResponse> {
    private final HealthAsyncClient client;
    private final DescribeAffectedAccountsForOrganizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAffectedAccountsForOrganizationPublisher(HealthAsyncClient client, DescribeAffectedAccountsForOrganizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAffectedAccountsForOrganizationPublisher(HealthAsyncClient client, DescribeAffectedAccountsForOrganizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAffectedAccountsForOrganizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAffectedAccountsForOrganizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> affectedAccounts() {
        Function<DescribeAffectedAccountsForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.affectedAccounts() != null) {
                return response.affectedAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAffectedAccountsForOrganizationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAffectedAccountsForOrganizationResponseFetcher
    implements AsyncPageFetcher<DescribeAffectedAccountsForOrganizationResponse> {
        private DescribeAffectedAccountsForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAffectedAccountsForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAffectedAccountsForOrganizationResponse> nextPage(DescribeAffectedAccountsForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return DescribeAffectedAccountsForOrganizationPublisher.this.client.describeAffectedAccountsForOrganization(DescribeAffectedAccountsForOrganizationPublisher.this.firstRequest);
            }
            return DescribeAffectedAccountsForOrganizationPublisher.this.client.describeAffectedAccountsForOrganization((DescribeAffectedAccountsForOrganizationRequest)((Object)DescribeAffectedAccountsForOrganizationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

