/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.services.health.model.OrganizationAccountIdsListCopier;
import software.amazon.awssdk.services.health.model.OrganizationEventArnsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEntityAggregatesForOrganizationRequest
extends HealthRequest
implements ToCopyableBuilder<Builder, DescribeEntityAggregatesForOrganizationRequest> {
    private static final SdkField<List<String>> EVENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventArns").getter(DescribeEntityAggregatesForOrganizationRequest.getter(DescribeEntityAggregatesForOrganizationRequest::eventArns)).setter(DescribeEntityAggregatesForOrganizationRequest.setter(Builder::eventArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AWS_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("awsAccountIds").getter(DescribeEntityAggregatesForOrganizationRequest.getter(DescribeEntityAggregatesForOrganizationRequest::awsAccountIds)).setter(DescribeEntityAggregatesForOrganizationRequest.setter(Builder::awsAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARNS_FIELD, AWS_ACCOUNT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEntityAggregatesForOrganizationRequest.memberNameToFieldInitializer();
    private final List<String> eventArns;
    private final List<String> awsAccountIds;

    private DescribeEntityAggregatesForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.eventArns = builder.eventArns;
        this.awsAccountIds = builder.awsAccountIds;
    }

    public final boolean hasEventArns() {
        return this.eventArns != null && !(this.eventArns instanceof SdkAutoConstructList);
    }

    public final List<String> eventArns() {
        return this.eventArns;
    }

    public final boolean hasAwsAccountIds() {
        return this.awsAccountIds != null && !(this.awsAccountIds instanceof SdkAutoConstructList);
    }

    public final List<String> awsAccountIds() {
        return this.awsAccountIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventArns() ? this.eventArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsAccountIds() ? this.awsAccountIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityAggregatesForOrganizationRequest)) {
            return false;
        }
        DescribeEntityAggregatesForOrganizationRequest other = (DescribeEntityAggregatesForOrganizationRequest)((Object)obj);
        return this.hasEventArns() == other.hasEventArns() && Objects.equals(this.eventArns(), other.eventArns()) && this.hasAwsAccountIds() == other.hasAwsAccountIds() && Objects.equals(this.awsAccountIds(), other.awsAccountIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEntityAggregatesForOrganizationRequest").add("EventArns", this.hasEventArns() ? this.eventArns() : null).add("AwsAccountIds", this.hasAwsAccountIds() ? this.awsAccountIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArns": {
                return Optional.ofNullable(clazz.cast(this.eventArns()));
            }
            case "awsAccountIds": {
                return Optional.ofNullable(clazz.cast(this.awsAccountIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("eventArns", EVENT_ARNS_FIELD);
        map.put("awsAccountIds", AWS_ACCOUNT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityAggregatesForOrganizationRequest, T> g) {
        return obj -> g.apply((DescribeEntityAggregatesForOrganizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthRequest.BuilderImpl
    implements Builder {
        private List<String> eventArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> awsAccountIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityAggregatesForOrganizationRequest model) {
            super(model);
            this.eventArns(model.eventArns);
            this.awsAccountIds(model.awsAccountIds);
        }

        public final Collection<String> getEventArns() {
            if (this.eventArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventArns;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = OrganizationEventArnsListCopier.copy(eventArns);
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = OrganizationEventArnsListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final Collection<String> getAwsAccountIds() {
            if (this.awsAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsAccountIds;
        }

        public final void setAwsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = OrganizationAccountIdsListCopier.copy(awsAccountIds);
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = OrganizationAccountIdsListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String ... awsAccountIds) {
            this.awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEntityAggregatesForOrganizationRequest build() {
            return new DescribeEntityAggregatesForOrganizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends HealthRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEntityAggregatesForOrganizationRequest> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder awsAccountIds(Collection<String> var1);

        public Builder awsAccountIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

