/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.ListMalwareScansRequest;
import software.amazon.awssdk.services.guardduty.model.ListMalwareScansResponse;
import software.amazon.awssdk.services.guardduty.model.MalwareScan;

public class ListMalwareScansPublisher
implements SdkPublisher<ListMalwareScansResponse> {
    private final GuardDutyAsyncClient client;
    private final ListMalwareScansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMalwareScansPublisher(GuardDutyAsyncClient client, ListMalwareScansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMalwareScansPublisher(GuardDutyAsyncClient client, ListMalwareScansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMalwareScansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMalwareScansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MalwareScan> scans() {
        Function<ListMalwareScansResponse, Iterator> getIterator = response -> {
            if (response != null && response.scans() != null) {
                return response.scans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMalwareScansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMalwareScansResponseFetcher
    implements AsyncPageFetcher<ListMalwareScansResponse> {
        private ListMalwareScansResponseFetcher() {
        }

        public boolean hasNextPage(ListMalwareScansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMalwareScansResponse> nextPage(ListMalwareScansResponse previousPage) {
            if (previousPage == null) {
                return ListMalwareScansPublisher.this.client.listMalwareScans(ListMalwareScansPublisher.this.firstRequest);
            }
            return ListMalwareScansPublisher.this.client.listMalwareScans((ListMalwareScansRequest)((Object)ListMalwareScansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

