/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.S3ObjectForSendObjectMalwareScan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendObjectMalwareScanRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, SendObjectMalwareScanRequest> {
    private static final SdkField<S3ObjectForSendObjectMalwareScan> S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Object").getter(SendObjectMalwareScanRequest.getter(SendObjectMalwareScanRequest::s3Object)).setter(SendObjectMalwareScanRequest.setter(Builder::s3Object)).constructor(S3ObjectForSendObjectMalwareScan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Object").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendObjectMalwareScanRequest.memberNameToFieldInitializer();
    private final S3ObjectForSendObjectMalwareScan s3Object;

    private SendObjectMalwareScanRequest(BuilderImpl builder) {
        super(builder);
        this.s3Object = builder.s3Object;
    }

    public final S3ObjectForSendObjectMalwareScan s3Object() {
        return this.s3Object;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Object());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendObjectMalwareScanRequest)) {
            return false;
        }
        SendObjectMalwareScanRequest other = (SendObjectMalwareScanRequest)((Object)obj);
        return Objects.equals(this.s3Object(), other.s3Object());
    }

    public final String toString() {
        return ToString.builder((String)"SendObjectMalwareScanRequest").add("S3Object", (Object)this.s3Object()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Object": {
                return Optional.ofNullable(clazz.cast(this.s3Object()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<S3ObjectForSendObjectMalwareScan>> map = new HashMap<String, SdkField<S3ObjectForSendObjectMalwareScan>>();
        map.put("s3Object", S3_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendObjectMalwareScanRequest, T> g) {
        return obj -> g.apply((SendObjectMalwareScanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private S3ObjectForSendObjectMalwareScan s3Object;

        private BuilderImpl() {
        }

        private BuilderImpl(SendObjectMalwareScanRequest model) {
            super(model);
            this.s3Object(model.s3Object);
        }

        public final S3ObjectForSendObjectMalwareScan.Builder getS3Object() {
            return this.s3Object != null ? this.s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3ObjectForSendObjectMalwareScan.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        @Override
        public final Builder s3Object(S3ObjectForSendObjectMalwareScan s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendObjectMalwareScanRequest build() {
            return new SendObjectMalwareScanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendObjectMalwareScanRequest> {
        public Builder s3Object(S3ObjectForSendObjectMalwareScan var1);

        default public Builder s3Object(Consumer<S3ObjectForSendObjectMalwareScan.Builder> s3Object) {
            return this.s3Object((S3ObjectForSendObjectMalwareScan)((S3ObjectForSendObjectMalwareScan.Builder)S3ObjectForSendObjectMalwareScan.builder().applyMutation(s3Object)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

