/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanStatusReason {
    ACCESS_DENIED("ACCESS_DENIED"),
    RESOURCE_NOT_FOUND("RESOURCE_NOT_FOUND"),
    SNAPSHOT_SIZE_LIMIT_EXCEEDED("SNAPSHOT_SIZE_LIMIT_EXCEEDED"),
    RESOURCE_UNAVAILABLE("RESOURCE_UNAVAILABLE"),
    INCONSISTENT_SOURCE("INCONSISTENT_SOURCE"),
    INCREMENTAL_NO_DIFFERENCE("INCREMENTAL_NO_DIFFERENCE"),
    NO_EBS_VOLUMES_FOUND("NO_EBS_VOLUMES_FOUND"),
    UNSUPPORTED_PRODUCT_CODE_TYPE("UNSUPPORTED_PRODUCT_CODE_TYPE"),
    AMI_SNAPSHOT_LIMIT_EXCEEDED("AMI_SNAPSHOT_LIMIT_EXCEEDED"),
    UNRELATED_RESOURCES("UNRELATED_RESOURCES"),
    BASE_RESOURCE_NOT_SCANNED("BASE_RESOURCE_NOT_SCANNED"),
    BASE_CREATED_AFTER_TARGET("BASE_CREATED_AFTER_TARGET"),
    UNSUPPORTED_FOR_INCREMENTAL("UNSUPPORTED_FOR_INCREMENTAL"),
    UNSUPPORTED_AMI("UNSUPPORTED_AMI"),
    UNSUPPORTED_SNAPSHOT("UNSUPPORTED_SNAPSHOT"),
    UNSUPPORTED_COMPOSITE_RECOVERY_POINT("UNSUPPORTED_COMPOSITE_RECOVERY_POINT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanStatusReason> VALUE_MAP;
    private final String value;

    private ScanStatusReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanStatusReason> knownValues() {
        EnumSet<ScanStatusReason> knownValues = EnumSet.allOf(ScanStatusReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanStatusReason.class, ScanStatusReason::toString);
    }
}

