/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.IncrementalScanDetails;
import software.amazon.awssdk.services.guardduty.model.ScanConfigurationRecoveryPoint;
import software.amazon.awssdk.services.guardduty.model.TriggerDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanConfiguration> {
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(ScanConfiguration.getter(ScanConfiguration::role)).setter(ScanConfiguration.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<TriggerDetails> TRIGGER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TriggerDetails").getter(ScanConfiguration.getter(ScanConfiguration::triggerDetails)).setter(ScanConfiguration.setter(Builder::triggerDetails)).constructor(TriggerDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerDetails").build()}).build();
    private static final SdkField<IncrementalScanDetails> INCREMENTAL_SCAN_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IncrementalScanDetails").getter(ScanConfiguration.getter(ScanConfiguration::incrementalScanDetails)).setter(ScanConfiguration.setter(Builder::incrementalScanDetails)).constructor(IncrementalScanDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalScanDetails").build()}).build();
    private static final SdkField<ScanConfigurationRecoveryPoint> RECOVERY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecoveryPoint").getter(ScanConfiguration.getter(ScanConfiguration::recoveryPoint)).setter(ScanConfiguration.setter(Builder::recoveryPoint)).constructor(ScanConfigurationRecoveryPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_FIELD, TRIGGER_DETAILS_FIELD, INCREMENTAL_SCAN_DETAILS_FIELD, RECOVERY_POINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScanConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String role;
    private final TriggerDetails triggerDetails;
    private final IncrementalScanDetails incrementalScanDetails;
    private final ScanConfigurationRecoveryPoint recoveryPoint;

    private ScanConfiguration(BuilderImpl builder) {
        this.role = builder.role;
        this.triggerDetails = builder.triggerDetails;
        this.incrementalScanDetails = builder.incrementalScanDetails;
        this.recoveryPoint = builder.recoveryPoint;
    }

    public final String role() {
        return this.role;
    }

    public final TriggerDetails triggerDetails() {
        return this.triggerDetails;
    }

    public final IncrementalScanDetails incrementalScanDetails() {
        return this.incrementalScanDetails;
    }

    public final ScanConfigurationRecoveryPoint recoveryPoint() {
        return this.recoveryPoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.incrementalScanDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanConfiguration)) {
            return false;
        }
        ScanConfiguration other = (ScanConfiguration)obj;
        return Objects.equals(this.role(), other.role()) && Objects.equals(this.triggerDetails(), other.triggerDetails()) && Objects.equals(this.incrementalScanDetails(), other.incrementalScanDetails()) && Objects.equals(this.recoveryPoint(), other.recoveryPoint());
    }

    public final String toString() {
        return ToString.builder((String)"ScanConfiguration").add("Role", (Object)this.role()).add("TriggerDetails", (Object)this.triggerDetails()).add("IncrementalScanDetails", (Object)this.incrementalScanDetails()).add("RecoveryPoint", (Object)this.recoveryPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "TriggerDetails": {
                return Optional.ofNullable(clazz.cast(this.triggerDetails()));
            }
            case "IncrementalScanDetails": {
                return Optional.ofNullable(clazz.cast(this.incrementalScanDetails()));
            }
            case "RecoveryPoint": {
                return Optional.ofNullable(clazz.cast(this.recoveryPoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("role", ROLE_FIELD);
        map.put("triggerDetails", TRIGGER_DETAILS_FIELD);
        map.put("incrementalScanDetails", INCREMENTAL_SCAN_DETAILS_FIELD);
        map.put("recoveryPoint", RECOVERY_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanConfiguration, T> g) {
        return obj -> g.apply((ScanConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String role;
        private TriggerDetails triggerDetails;
        private IncrementalScanDetails incrementalScanDetails;
        private ScanConfigurationRecoveryPoint recoveryPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanConfiguration model) {
            this.role(model.role);
            this.triggerDetails(model.triggerDetails);
            this.incrementalScanDetails(model.incrementalScanDetails);
            this.recoveryPoint(model.recoveryPoint);
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final TriggerDetails.Builder getTriggerDetails() {
            return this.triggerDetails != null ? this.triggerDetails.toBuilder() : null;
        }

        public final void setTriggerDetails(TriggerDetails.BuilderImpl triggerDetails) {
            this.triggerDetails = triggerDetails != null ? triggerDetails.build() : null;
        }

        @Override
        public final Builder triggerDetails(TriggerDetails triggerDetails) {
            this.triggerDetails = triggerDetails;
            return this;
        }

        public final IncrementalScanDetails.Builder getIncrementalScanDetails() {
            return this.incrementalScanDetails != null ? this.incrementalScanDetails.toBuilder() : null;
        }

        public final void setIncrementalScanDetails(IncrementalScanDetails.BuilderImpl incrementalScanDetails) {
            this.incrementalScanDetails = incrementalScanDetails != null ? incrementalScanDetails.build() : null;
        }

        @Override
        public final Builder incrementalScanDetails(IncrementalScanDetails incrementalScanDetails) {
            this.incrementalScanDetails = incrementalScanDetails;
            return this;
        }

        public final ScanConfigurationRecoveryPoint.Builder getRecoveryPoint() {
            return this.recoveryPoint != null ? this.recoveryPoint.toBuilder() : null;
        }

        public final void setRecoveryPoint(ScanConfigurationRecoveryPoint.BuilderImpl recoveryPoint) {
            this.recoveryPoint = recoveryPoint != null ? recoveryPoint.build() : null;
        }

        @Override
        public final Builder recoveryPoint(ScanConfigurationRecoveryPoint recoveryPoint) {
            this.recoveryPoint = recoveryPoint;
            return this;
        }

        public ScanConfiguration build() {
            return new ScanConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanConfiguration> {
        public Builder role(String var1);

        public Builder triggerDetails(TriggerDetails var1);

        default public Builder triggerDetails(Consumer<TriggerDetails.Builder> triggerDetails) {
            return this.triggerDetails((TriggerDetails)((TriggerDetails.Builder)TriggerDetails.builder().applyMutation(triggerDetails)).build());
        }

        public Builder incrementalScanDetails(IncrementalScanDetails var1);

        default public Builder incrementalScanDetails(Consumer<IncrementalScanDetails.Builder> incrementalScanDetails) {
            return this.incrementalScanDetails((IncrementalScanDetails)((IncrementalScanDetails.Builder)IncrementalScanDetails.builder().applyMutation(incrementalScanDetails)).build());
        }

        public Builder recoveryPoint(ScanConfigurationRecoveryPoint var1);

        default public Builder recoveryPoint(Consumer<ScanConfigurationRecoveryPoint.Builder> recoveryPoint) {
            return this.recoveryPoint((ScanConfigurationRecoveryPoint)((ScanConfigurationRecoveryPoint.Builder)ScanConfigurationRecoveryPoint.builder().applyMutation(recoveryPoint)).build());
        }
    }
}

