/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.endpoints.internal;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.guardduty.endpoints.internal.DefaultPartitionDataProvider;
import software.amazon.awssdk.services.guardduty.endpoints.internal.Partition;
import software.amazon.awssdk.services.guardduty.endpoints.internal.Partitions;
import software.amazon.awssdk.services.guardduty.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.guardduty.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.guardduty.endpoints.internal.RuleUrl;

@SdkInternalApi
public class RulesFunctions {
    private static final String[] ENCODED_CHARACTERS = new String[]{"+", "*", "%7E"};
    private static final String[] ENCODED_CHARACTERS_REPLACEMENTS = new String[]{"%20", "%2A", "~"};
    private static final LazyValue<PartitionData> PARTITION_DATA = LazyValue.builder().initializer(RulesFunctions::loadPartitionData).build();
    private static final LazyValue<Partition> AWS_PARTITION = LazyValue.builder().initializer(RulesFunctions::findAwsPartition).build();
    private static final int MAX_HOST_LABEL_SIZE = 63;
    private static final int MIN_BUCKET_SIZE = 3;

    public static String substring(String value, int startIndex, int stopIndex, boolean reverse) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        if (startIndex >= stopIndex || len < stopIndex) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            if (value.charAt(i) <= '\u007f') continue;
            return null;
        }
        if (reverse) {
            int revStart = len - stopIndex;
            int revStop = len - startIndex;
            return value.substring(revStart, revStop);
        }
        return value.substring(startIndex, stopIndex);
    }

    public static String uriEncode(String uri) {
        try {
            String encoded = URLEncoder.encode(uri, "UTF-8");
            for (int i = 0; i < ENCODED_CHARACTERS.length; ++i) {
                encoded = encoded.replace(ENCODED_CHARACTERS[i], ENCODED_CHARACTERS_REPLACEMENTS[i]);
            }
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw SdkClientException.create((String)("Unable to URI encode value: " + uri), (Throwable)e);
        }
    }

    public static RuleUrl parseURL(String url) {
        try {
            return RuleUrl.parse(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static boolean isValidHostLabel(String hostLabel, boolean allowDots) {
        int len;
        int n = len = hostLabel == null ? 0 : hostLabel.length();
        if (len == 0) {
            return false;
        }
        if (!allowDots) {
            return RulesFunctions.isValidSingleLabel(hostLabel, 0, len);
        }
        int start = 0;
        for (int i = 0; i <= len; ++i) {
            if (i != len && hostLabel.charAt(i) != '.') continue;
            int chunkLen = i - start;
            if (chunkLen < 1 || chunkLen > 63) {
                return false;
            }
            if (!RulesFunctions.isValidSingleLabel(hostLabel, start, i)) {
                return false;
            }
            start = i + 1;
        }
        return true;
    }

    private static boolean isValidSingleLabel(String s, int start, int end) {
        int length = end - start;
        if (length < 1 || length > 63) {
            return false;
        }
        if (!RulesFunctions.isAlphanumeric(s.charAt(start))) {
            return false;
        }
        for (int i = start + 1; i < end; ++i) {
            char c = s.charAt(i);
            if (RulesFunctions.isAlphanumeric(c) || c == '-') continue;
            return false;
        }
        return true;
    }

    private static boolean isAlphanumeric(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isLowerCaseAlphanumeric(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    public static RulePartition awsPartition(String regionName) {
        PartitionData data = PARTITION_DATA.value();
        Partition matchedPartition = (Partition)data.regionMap.get(regionName);
        if (matchedPartition == null) {
            for (Partition p : data.partitions) {
                if (!p.regionMatches(regionName)) continue;
                matchedPartition = p;
                break;
            }
        }
        if (matchedPartition == null) {
            matchedPartition = AWS_PARTITION.value();
        }
        return RulePartition.from(matchedPartition.id(), matchedPartition.outputs());
    }

    public static RuleArn awsParseArn(String value) {
        return RuleArn.parse(value);
    }

    public static boolean stringEquals(String left, String right) {
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public static <T> T listAccess(List<T> values, int index) {
        if (values == null) {
            return null;
        }
        if (index >= values.size()) {
            return null;
        }
        return values.get(index);
    }

    public static boolean awsIsVirtualHostableS3Bucket(String hostLabel, boolean allowDots) {
        int bucketLength;
        int n = bucketLength = hostLabel == null ? 0 : hostLabel.length();
        if (bucketLength < 3 || bucketLength > 63) {
            return false;
        }
        if (!RulesFunctions.isLowerCaseAlphanumeric(hostLabel.charAt(0)) || !RulesFunctions.isLowerCaseAlphanumeric(hostLabel.charAt(bucketLength - 1))) {
            return false;
        }
        if (!allowDots) {
            for (int i = 1; i < bucketLength - 1; ++i) {
                if (RulesFunctions.isValidBucketSegmentChar(hostLabel.charAt(i))) continue;
                return false;
            }
            return true;
        }
        char last = hostLabel.charAt(0);
        for (int i = 1; i < bucketLength; ++i) {
            char c = hostLabel.charAt(i);
            if (c == '.' ? last == '.' || last == '-' : (c == '-' ? last == '.' : !RulesFunctions.isLowerCaseAlphanumeric(c))) {
                return false;
            }
            last = c;
        }
        return !RulesFunctions.isIpAddr(hostLabel);
    }

    private static boolean isValidBucketSegmentChar(char c) {
        return RulesFunctions.isLowerCaseAlphanumeric(c) || c == '-';
    }

    private static boolean isIpAddr(String host) {
        if (host == null || host.length() < 2) {
            return false;
        }
        if (host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']') {
            return true;
        }
        int from = 0;
        int segments = 0;
        boolean done = false;
        while (!done) {
            char ch1;
            char ch0;
            int index = host.indexOf(46, from);
            if (index == -1) {
                if (segments != 3) {
                    return false;
                }
                index = host.length();
                done = true;
            } else if (segments == 3) {
                return false;
            }
            int length = index - from;
            if (length == 1) {
                ch0 = host.charAt(from);
                if (ch0 < '0' || ch0 > '9') {
                    return false;
                }
            } else if (length == 2) {
                ch0 = host.charAt(from);
                ch1 = host.charAt(from + 1);
                if (ch0 <= '0' || ch0 > '9' || ch1 < '0' || ch1 > '9') {
                    return false;
                }
            } else if (length == 3) {
                ch0 = host.charAt(from);
                ch1 = host.charAt(from + 1);
                char ch2 = host.charAt(from + 2);
                if (ch0 <= '0' || ch0 > '9' || ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9') {
                    return false;
                }
            } else {
                return false;
            }
            from = index + 1;
            ++segments;
        }
        return true;
    }

    private static PartitionData loadPartitionData() {
        DefaultPartitionDataProvider provider = new DefaultPartitionDataProvider();
        Partitions partitions = provider.loadPartitions();
        PartitionData partitionData = new PartitionData();
        partitions.partitions().forEach(part -> {
            partitionData.partitions.add(part);
            part.regions().forEach((name, override) -> partitionData.regionMap.put(name, part));
        });
        return partitionData;
    }

    private static Partition findAwsPartition() {
        return PARTITION_DATA.value().partitions.stream().filter(p -> p.id().equalsIgnoreCase("aws")).findFirst().orElse(null);
    }

    private static final class LazyValue<T> {
        private final Supplier<T> initializer;
        private T value;
        private boolean initialized;

        private LazyValue(Builder<T> builder) {
            this.initializer = ((Builder)builder).initializer;
        }

        public T value() {
            if (!this.initialized) {
                this.value = this.initializer.get();
                this.initialized = true;
            }
            return this.value;
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T> {
            private Supplier<T> initializer;

            public Builder<T> initializer(Supplier<T> initializer) {
                this.initializer = initializer;
                return this;
            }

            public LazyValue<T> build() {
                return new LazyValue(this);
            }
        }
    }

    private static class PartitionData {
        private final List<Partition> partitions = new ArrayList<Partition>();
        private final Map<String, Partition> regionMap = new HashMap<String, Partition>();

        private PartitionData() {
        }
    }
}

