/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionResourceType;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionScanStatus;
import software.amazon.awssdk.services.guardduty.model.ScanStatusReason;
import software.amazon.awssdk.services.guardduty.model.ScannedResourceDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScannedResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScannedResource> {
    private static final SdkField<String> SCANNED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScannedResourceArn").getter(ScannedResource.getter(ScannedResource::scannedResourceArn)).setter(ScannedResource.setter(Builder::scannedResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scannedResourceArn").build()}).build();
    private static final SdkField<String> SCANNED_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScannedResourceType").getter(ScannedResource.getter(ScannedResource::scannedResourceTypeAsString)).setter(ScannedResource.setter(Builder::scannedResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scannedResourceType").build()}).build();
    private static final SdkField<String> SCANNED_RESOURCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScannedResourceStatus").getter(ScannedResource.getter(ScannedResource::scannedResourceStatusAsString)).setter(ScannedResource.setter(Builder::scannedResourceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scannedResourceStatus").build()}).build();
    private static final SdkField<String> SCAN_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanStatusReason").getter(ScannedResource.getter(ScannedResource::scanStatusReasonAsString)).setter(ScannedResource.setter(Builder::scanStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatusReason").build()}).build();
    private static final SdkField<ScannedResourceDetails> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDetails").getter(ScannedResource.getter(ScannedResource::resourceDetails)).setter(ScannedResource.setter(Builder::resourceDetails)).constructor(ScannedResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCANNED_RESOURCE_ARN_FIELD, SCANNED_RESOURCE_TYPE_FIELD, SCANNED_RESOURCE_STATUS_FIELD, SCAN_STATUS_REASON_FIELD, RESOURCE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScannedResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scannedResourceArn;
    private final String scannedResourceType;
    private final String scannedResourceStatus;
    private final String scanStatusReason;
    private final ScannedResourceDetails resourceDetails;

    private ScannedResource(BuilderImpl builder) {
        this.scannedResourceArn = builder.scannedResourceArn;
        this.scannedResourceType = builder.scannedResourceType;
        this.scannedResourceStatus = builder.scannedResourceStatus;
        this.scanStatusReason = builder.scanStatusReason;
        this.resourceDetails = builder.resourceDetails;
    }

    public final String scannedResourceArn() {
        return this.scannedResourceArn;
    }

    public final MalwareProtectionResourceType scannedResourceType() {
        return MalwareProtectionResourceType.fromValue(this.scannedResourceType);
    }

    public final String scannedResourceTypeAsString() {
        return this.scannedResourceType;
    }

    public final MalwareProtectionScanStatus scannedResourceStatus() {
        return MalwareProtectionScanStatus.fromValue(this.scannedResourceStatus);
    }

    public final String scannedResourceStatusAsString() {
        return this.scannedResourceStatus;
    }

    public final ScanStatusReason scanStatusReason() {
        return ScanStatusReason.fromValue(this.scanStatusReason);
    }

    public final String scanStatusReasonAsString() {
        return this.scanStatusReason;
    }

    public final ScannedResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scannedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scannedResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scannedResourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStatusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScannedResource)) {
            return false;
        }
        ScannedResource other = (ScannedResource)obj;
        return Objects.equals(this.scannedResourceArn(), other.scannedResourceArn()) && Objects.equals(this.scannedResourceTypeAsString(), other.scannedResourceTypeAsString()) && Objects.equals(this.scannedResourceStatusAsString(), other.scannedResourceStatusAsString()) && Objects.equals(this.scanStatusReasonAsString(), other.scanStatusReasonAsString()) && Objects.equals(this.resourceDetails(), other.resourceDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ScannedResource").add("ScannedResourceArn", (Object)this.scannedResourceArn()).add("ScannedResourceType", (Object)this.scannedResourceTypeAsString()).add("ScannedResourceStatus", (Object)this.scannedResourceStatusAsString()).add("ScanStatusReason", (Object)this.scanStatusReasonAsString()).add("ResourceDetails", (Object)this.resourceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScannedResourceArn": {
                return Optional.ofNullable(clazz.cast(this.scannedResourceArn()));
            }
            case "ScannedResourceType": {
                return Optional.ofNullable(clazz.cast(this.scannedResourceTypeAsString()));
            }
            case "ScannedResourceStatus": {
                return Optional.ofNullable(clazz.cast(this.scannedResourceStatusAsString()));
            }
            case "ScanStatusReason": {
                return Optional.ofNullable(clazz.cast(this.scanStatusReasonAsString()));
            }
            case "ResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scannedResourceArn", SCANNED_RESOURCE_ARN_FIELD);
        map.put("scannedResourceType", SCANNED_RESOURCE_TYPE_FIELD);
        map.put("scannedResourceStatus", SCANNED_RESOURCE_STATUS_FIELD);
        map.put("scanStatusReason", SCAN_STATUS_REASON_FIELD);
        map.put("resourceDetails", RESOURCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScannedResource, T> g) {
        return obj -> g.apply((ScannedResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scannedResourceArn;
        private String scannedResourceType;
        private String scannedResourceStatus;
        private String scanStatusReason;
        private ScannedResourceDetails resourceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ScannedResource model) {
            this.scannedResourceArn(model.scannedResourceArn);
            this.scannedResourceType(model.scannedResourceType);
            this.scannedResourceStatus(model.scannedResourceStatus);
            this.scanStatusReason(model.scanStatusReason);
            this.resourceDetails(model.resourceDetails);
        }

        public final String getScannedResourceArn() {
            return this.scannedResourceArn;
        }

        public final void setScannedResourceArn(String scannedResourceArn) {
            this.scannedResourceArn = scannedResourceArn;
        }

        @Override
        public final Builder scannedResourceArn(String scannedResourceArn) {
            this.scannedResourceArn = scannedResourceArn;
            return this;
        }

        public final String getScannedResourceType() {
            return this.scannedResourceType;
        }

        public final void setScannedResourceType(String scannedResourceType) {
            this.scannedResourceType = scannedResourceType;
        }

        @Override
        public final Builder scannedResourceType(String scannedResourceType) {
            this.scannedResourceType = scannedResourceType;
            return this;
        }

        @Override
        public final Builder scannedResourceType(MalwareProtectionResourceType scannedResourceType) {
            this.scannedResourceType(scannedResourceType == null ? null : scannedResourceType.toString());
            return this;
        }

        public final String getScannedResourceStatus() {
            return this.scannedResourceStatus;
        }

        public final void setScannedResourceStatus(String scannedResourceStatus) {
            this.scannedResourceStatus = scannedResourceStatus;
        }

        @Override
        public final Builder scannedResourceStatus(String scannedResourceStatus) {
            this.scannedResourceStatus = scannedResourceStatus;
            return this;
        }

        @Override
        public final Builder scannedResourceStatus(MalwareProtectionScanStatus scannedResourceStatus) {
            this.scannedResourceStatus(scannedResourceStatus == null ? null : scannedResourceStatus.toString());
            return this;
        }

        public final String getScanStatusReason() {
            return this.scanStatusReason;
        }

        public final void setScanStatusReason(String scanStatusReason) {
            this.scanStatusReason = scanStatusReason;
        }

        @Override
        public final Builder scanStatusReason(String scanStatusReason) {
            this.scanStatusReason = scanStatusReason;
            return this;
        }

        @Override
        public final Builder scanStatusReason(ScanStatusReason scanStatusReason) {
            this.scanStatusReason(scanStatusReason == null ? null : scanStatusReason.toString());
            return this;
        }

        public final ScannedResourceDetails.Builder getResourceDetails() {
            return this.resourceDetails != null ? this.resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ScannedResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ScannedResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public ScannedResource build() {
            return new ScannedResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScannedResource> {
        public Builder scannedResourceArn(String var1);

        public Builder scannedResourceType(String var1);

        public Builder scannedResourceType(MalwareProtectionResourceType var1);

        public Builder scannedResourceStatus(String var1);

        public Builder scannedResourceStatus(MalwareProtectionScanStatus var1);

        public Builder scanStatusReason(String var1);

        public Builder scanStatusReason(ScanStatusReason var1);

        public Builder resourceDetails(ScannedResourceDetails var1);

        default public Builder resourceDetails(Consumer<ScannedResourceDetails.Builder> resourceDetails) {
            return this.resourceDetails((ScannedResourceDetails)((ScannedResourceDetails.Builder)ScannedResourceDetails.builder().applyMutation(resourceDetails)).build());
        }
    }
}

