/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MalwareProtectionScanStatus {
    RUNNING("RUNNING"),
    COMPLETED("COMPLETED"),
    COMPLETED_WITH_ISSUES("COMPLETED_WITH_ISSUES"),
    FAILED("FAILED"),
    SKIPPED("SKIPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MalwareProtectionScanStatus> VALUE_MAP;
    private final String value;

    private MalwareProtectionScanStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MalwareProtectionScanStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MalwareProtectionScanStatus> knownValues() {
        EnumSet<MalwareProtectionScanStatus> knownValues = EnumSet.allOf(MalwareProtectionScanStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MalwareProtectionScanStatus.class, MalwareProtectionScanStatus::toString);
    }
}

