/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.ListMalwareScansFilterCriteria;
import software.amazon.awssdk.services.guardduty.model.SortCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMalwareScansRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, ListMalwareScansRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListMalwareScansRequest.getter(ListMalwareScansRequest::maxResults)).setter(ListMalwareScansRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMalwareScansRequest.getter(ListMalwareScansRequest::nextToken)).setter(ListMalwareScansRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<ListMalwareScansFilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCriteria").getter(ListMalwareScansRequest.getter(ListMalwareScansRequest::filterCriteria)).setter(ListMalwareScansRequest.setter(Builder::filterCriteria)).constructor(ListMalwareScansFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()}).build();
    private static final SdkField<SortCriteria> SORT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortCriteria").getter(ListMalwareScansRequest.getter(ListMalwareScansRequest::sortCriteria)).setter(ListMalwareScansRequest.setter(Builder::sortCriteria)).constructor(SortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTER_CRITERIA_FIELD, SORT_CRITERIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMalwareScansRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final ListMalwareScansFilterCriteria filterCriteria;
    private final SortCriteria sortCriteria;

    private ListMalwareScansRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filterCriteria = builder.filterCriteria;
        this.sortCriteria = builder.sortCriteria;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ListMalwareScansFilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final SortCriteria sortCriteria() {
        return this.sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMalwareScansRequest)) {
            return false;
        }
        ListMalwareScansRequest other = (ListMalwareScansRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.sortCriteria(), other.sortCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"ListMalwareScansRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("FilterCriteria", (Object)this.filterCriteria()).add("SortCriteria", (Object)this.sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FilterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "SortCriteria": {
                return Optional.ofNullable(clazz.cast(this.sortCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("filterCriteria", FILTER_CRITERIA_FIELD);
        map.put("sortCriteria", SORT_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMalwareScansRequest, T> g) {
        return obj -> g.apply((ListMalwareScansRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private ListMalwareScansFilterCriteria filterCriteria;
        private SortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMalwareScansRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.filterCriteria(model.filterCriteria);
            this.sortCriteria(model.sortCriteria);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ListMalwareScansFilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(ListMalwareScansFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(ListMalwareScansFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final SortCriteria.Builder getSortCriteria() {
            return this.sortCriteria != null ? this.sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(SortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(SortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMalwareScansRequest build() {
            return new ListMalwareScansRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMalwareScansRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder filterCriteria(ListMalwareScansFilterCriteria var1);

        default public Builder filterCriteria(Consumer<ListMalwareScansFilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((ListMalwareScansFilterCriteria)((ListMalwareScansFilterCriteria.Builder)ListMalwareScansFilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder sortCriteria(SortCriteria var1);

        default public Builder sortCriteria(Consumer<SortCriteria.Builder> sortCriteria) {
            return this.sortCriteria((SortCriteria)((SortCriteria.Builder)SortCriteria.builder().applyMutation(sortCriteria)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

