/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GetMalwareScanResultDetails;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionResourceType;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionScanStatus;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionScanType;
import software.amazon.awssdk.services.guardduty.model.ScanCategory;
import software.amazon.awssdk.services.guardduty.model.ScanConfiguration;
import software.amazon.awssdk.services.guardduty.model.ScanStatusReason;
import software.amazon.awssdk.services.guardduty.model.ScannedResource;
import software.amazon.awssdk.services.guardduty.model.ScannedResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMalwareScanResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetMalwareScanResponse> {
    private static final SdkField<String> SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanId").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scanId)).setter(GetMalwareScanResponse.setter(Builder::scanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanId").build()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::detectorId)).setter(GetMalwareScanResponse.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> ADMIN_DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdminDetectorId").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::adminDetectorId)).setter(GetMalwareScanResponse.setter(Builder::adminDetectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminDetectorId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::resourceArn)).setter(GetMalwareScanResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::resourceTypeAsString)).setter(GetMalwareScanResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Integer> SCANNED_RESOURCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScannedResourcesCount").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scannedResourcesCount)).setter(GetMalwareScanResponse.setter(Builder::scannedResourcesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scannedResourcesCount").build()}).build();
    private static final SdkField<Integer> SKIPPED_RESOURCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SkippedResourcesCount").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::skippedResourcesCount)).setter(GetMalwareScanResponse.setter(Builder::skippedResourcesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedResourcesCount").build()}).build();
    private static final SdkField<Integer> FAILED_RESOURCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedResourcesCount").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::failedResourcesCount)).setter(GetMalwareScanResponse.setter(Builder::failedResourcesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedResourcesCount").build()}).build();
    private static final SdkField<List<ScannedResource>> SCANNED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScannedResources").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scannedResources)).setter(GetMalwareScanResponse.setter(Builder::scannedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scannedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScannedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ScanConfiguration> SCAN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScanConfiguration").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scanConfiguration)).setter(GetMalwareScanResponse.setter(Builder::scanConfiguration)).constructor(ScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfiguration").build()}).build();
    private static final SdkField<String> SCAN_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanCategory").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scanCategoryAsString)).setter(GetMalwareScanResponse.setter(Builder::scanCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanCategory").build()}).build();
    private static final SdkField<String> SCAN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanStatus").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scanStatusAsString)).setter(GetMalwareScanResponse.setter(Builder::scanStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatus").build()}).build();
    private static final SdkField<String> SCAN_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanStatusReason").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scanStatusReasonAsString)).setter(GetMalwareScanResponse.setter(Builder::scanStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatusReason").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scanTypeAsString)).setter(GetMalwareScanResponse.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final SdkField<Instant> SCAN_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScanStartedAt").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scanStartedAt)).setter(GetMalwareScanResponse.setter(Builder::scanStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStartedAt").build()}).build();
    private static final SdkField<Instant> SCAN_COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScanCompletedAt").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scanCompletedAt)).setter(GetMalwareScanResponse.setter(Builder::scanCompletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanCompletedAt").build()}).build();
    private static final SdkField<GetMalwareScanResultDetails> SCAN_RESULT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScanResultDetails").getter(GetMalwareScanResponse.getter(GetMalwareScanResponse::scanResultDetails)).setter(GetMalwareScanResponse.setter(Builder::scanResultDetails)).constructor(GetMalwareScanResultDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanResultDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ID_FIELD, DETECTOR_ID_FIELD, ADMIN_DETECTOR_ID_FIELD, RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, SCANNED_RESOURCES_COUNT_FIELD, SKIPPED_RESOURCES_COUNT_FIELD, FAILED_RESOURCES_COUNT_FIELD, SCANNED_RESOURCES_FIELD, SCAN_CONFIGURATION_FIELD, SCAN_CATEGORY_FIELD, SCAN_STATUS_FIELD, SCAN_STATUS_REASON_FIELD, SCAN_TYPE_FIELD, SCAN_STARTED_AT_FIELD, SCAN_COMPLETED_AT_FIELD, SCAN_RESULT_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMalwareScanResponse.memberNameToFieldInitializer();
    private final String scanId;
    private final String detectorId;
    private final String adminDetectorId;
    private final String resourceArn;
    private final String resourceType;
    private final Integer scannedResourcesCount;
    private final Integer skippedResourcesCount;
    private final Integer failedResourcesCount;
    private final List<ScannedResource> scannedResources;
    private final ScanConfiguration scanConfiguration;
    private final String scanCategory;
    private final String scanStatus;
    private final String scanStatusReason;
    private final String scanType;
    private final Instant scanStartedAt;
    private final Instant scanCompletedAt;
    private final GetMalwareScanResultDetails scanResultDetails;

    private GetMalwareScanResponse(BuilderImpl builder) {
        super(builder);
        this.scanId = builder.scanId;
        this.detectorId = builder.detectorId;
        this.adminDetectorId = builder.adminDetectorId;
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.scannedResourcesCount = builder.scannedResourcesCount;
        this.skippedResourcesCount = builder.skippedResourcesCount;
        this.failedResourcesCount = builder.failedResourcesCount;
        this.scannedResources = builder.scannedResources;
        this.scanConfiguration = builder.scanConfiguration;
        this.scanCategory = builder.scanCategory;
        this.scanStatus = builder.scanStatus;
        this.scanStatusReason = builder.scanStatusReason;
        this.scanType = builder.scanType;
        this.scanStartedAt = builder.scanStartedAt;
        this.scanCompletedAt = builder.scanCompletedAt;
        this.scanResultDetails = builder.scanResultDetails;
    }

    public final String scanId() {
        return this.scanId;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String adminDetectorId() {
        return this.adminDetectorId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final MalwareProtectionResourceType resourceType() {
        return MalwareProtectionResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Integer scannedResourcesCount() {
        return this.scannedResourcesCount;
    }

    public final Integer skippedResourcesCount() {
        return this.skippedResourcesCount;
    }

    public final Integer failedResourcesCount() {
        return this.failedResourcesCount;
    }

    public final boolean hasScannedResources() {
        return this.scannedResources != null && !(this.scannedResources instanceof SdkAutoConstructList);
    }

    public final List<ScannedResource> scannedResources() {
        return this.scannedResources;
    }

    public final ScanConfiguration scanConfiguration() {
        return this.scanConfiguration;
    }

    public final ScanCategory scanCategory() {
        return ScanCategory.fromValue(this.scanCategory);
    }

    public final String scanCategoryAsString() {
        return this.scanCategory;
    }

    public final MalwareProtectionScanStatus scanStatus() {
        return MalwareProtectionScanStatus.fromValue(this.scanStatus);
    }

    public final String scanStatusAsString() {
        return this.scanStatus;
    }

    public final ScanStatusReason scanStatusReason() {
        return ScanStatusReason.fromValue(this.scanStatusReason);
    }

    public final String scanStatusReasonAsString() {
        return this.scanStatusReason;
    }

    public final MalwareProtectionScanType scanType() {
        return MalwareProtectionScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public final Instant scanStartedAt() {
        return this.scanStartedAt;
    }

    public final Instant scanCompletedAt() {
        return this.scanCompletedAt;
    }

    public final GetMalwareScanResultDetails scanResultDetails() {
        return this.scanResultDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminDetectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scannedResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.skippedResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScannedResources() ? this.scannedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scanConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStatusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanCompletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanResultDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMalwareScanResponse)) {
            return false;
        }
        GetMalwareScanResponse other = (GetMalwareScanResponse)((Object)obj);
        return Objects.equals(this.scanId(), other.scanId()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.adminDetectorId(), other.adminDetectorId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.scannedResourcesCount(), other.scannedResourcesCount()) && Objects.equals(this.skippedResourcesCount(), other.skippedResourcesCount()) && Objects.equals(this.failedResourcesCount(), other.failedResourcesCount()) && this.hasScannedResources() == other.hasScannedResources() && Objects.equals(this.scannedResources(), other.scannedResources()) && Objects.equals(this.scanConfiguration(), other.scanConfiguration()) && Objects.equals(this.scanCategoryAsString(), other.scanCategoryAsString()) && Objects.equals(this.scanStatusAsString(), other.scanStatusAsString()) && Objects.equals(this.scanStatusReasonAsString(), other.scanStatusReasonAsString()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString()) && Objects.equals(this.scanStartedAt(), other.scanStartedAt()) && Objects.equals(this.scanCompletedAt(), other.scanCompletedAt()) && Objects.equals(this.scanResultDetails(), other.scanResultDetails());
    }

    public final String toString() {
        return ToString.builder((String)"GetMalwareScanResponse").add("ScanId", (Object)this.scanId()).add("DetectorId", (Object)this.detectorId()).add("AdminDetectorId", (Object)this.adminDetectorId()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ScannedResourcesCount", (Object)this.scannedResourcesCount()).add("SkippedResourcesCount", (Object)this.skippedResourcesCount()).add("FailedResourcesCount", (Object)this.failedResourcesCount()).add("ScannedResources", this.hasScannedResources() ? this.scannedResources() : null).add("ScanConfiguration", (Object)this.scanConfiguration()).add("ScanCategory", (Object)this.scanCategoryAsString()).add("ScanStatus", (Object)this.scanStatusAsString()).add("ScanStatusReason", (Object)this.scanStatusReasonAsString()).add("ScanType", (Object)this.scanTypeAsString()).add("ScanStartedAt", (Object)this.scanStartedAt()).add("ScanCompletedAt", (Object)this.scanCompletedAt()).add("ScanResultDetails", (Object)this.scanResultDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScanId": {
                return Optional.ofNullable(clazz.cast(this.scanId()));
            }
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "AdminDetectorId": {
                return Optional.ofNullable(clazz.cast(this.adminDetectorId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ScannedResourcesCount": {
                return Optional.ofNullable(clazz.cast(this.scannedResourcesCount()));
            }
            case "SkippedResourcesCount": {
                return Optional.ofNullable(clazz.cast(this.skippedResourcesCount()));
            }
            case "FailedResourcesCount": {
                return Optional.ofNullable(clazz.cast(this.failedResourcesCount()));
            }
            case "ScannedResources": {
                return Optional.ofNullable(clazz.cast(this.scannedResources()));
            }
            case "ScanConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scanConfiguration()));
            }
            case "ScanCategory": {
                return Optional.ofNullable(clazz.cast(this.scanCategoryAsString()));
            }
            case "ScanStatus": {
                return Optional.ofNullable(clazz.cast(this.scanStatusAsString()));
            }
            case "ScanStatusReason": {
                return Optional.ofNullable(clazz.cast(this.scanStatusReasonAsString()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
            case "ScanStartedAt": {
                return Optional.ofNullable(clazz.cast(this.scanStartedAt()));
            }
            case "ScanCompletedAt": {
                return Optional.ofNullable(clazz.cast(this.scanCompletedAt()));
            }
            case "ScanResultDetails": {
                return Optional.ofNullable(clazz.cast(this.scanResultDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scanId", SCAN_ID_FIELD);
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("adminDetectorId", ADMIN_DETECTOR_ID_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("scannedResourcesCount", SCANNED_RESOURCES_COUNT_FIELD);
        map.put("skippedResourcesCount", SKIPPED_RESOURCES_COUNT_FIELD);
        map.put("failedResourcesCount", FAILED_RESOURCES_COUNT_FIELD);
        map.put("scannedResources", SCANNED_RESOURCES_FIELD);
        map.put("scanConfiguration", SCAN_CONFIGURATION_FIELD);
        map.put("scanCategory", SCAN_CATEGORY_FIELD);
        map.put("scanStatus", SCAN_STATUS_FIELD);
        map.put("scanStatusReason", SCAN_STATUS_REASON_FIELD);
        map.put("scanType", SCAN_TYPE_FIELD);
        map.put("scanStartedAt", SCAN_STARTED_AT_FIELD);
        map.put("scanCompletedAt", SCAN_COMPLETED_AT_FIELD);
        map.put("scanResultDetails", SCAN_RESULT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMalwareScanResponse, T> g) {
        return obj -> g.apply((GetMalwareScanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private String scanId;
        private String detectorId;
        private String adminDetectorId;
        private String resourceArn;
        private String resourceType;
        private Integer scannedResourcesCount;
        private Integer skippedResourcesCount;
        private Integer failedResourcesCount;
        private List<ScannedResource> scannedResources = DefaultSdkAutoConstructList.getInstance();
        private ScanConfiguration scanConfiguration;
        private String scanCategory;
        private String scanStatus;
        private String scanStatusReason;
        private String scanType;
        private Instant scanStartedAt;
        private Instant scanCompletedAt;
        private GetMalwareScanResultDetails scanResultDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMalwareScanResponse model) {
            super(model);
            this.scanId(model.scanId);
            this.detectorId(model.detectorId);
            this.adminDetectorId(model.adminDetectorId);
            this.resourceArn(model.resourceArn);
            this.resourceType(model.resourceType);
            this.scannedResourcesCount(model.scannedResourcesCount);
            this.skippedResourcesCount(model.skippedResourcesCount);
            this.failedResourcesCount(model.failedResourcesCount);
            this.scannedResources(model.scannedResources);
            this.scanConfiguration(model.scanConfiguration);
            this.scanCategory(model.scanCategory);
            this.scanStatus(model.scanStatus);
            this.scanStatusReason(model.scanStatusReason);
            this.scanType(model.scanType);
            this.scanStartedAt(model.scanStartedAt);
            this.scanCompletedAt(model.scanCompletedAt);
            this.scanResultDetails(model.scanResultDetails);
        }

        public final String getScanId() {
            return this.scanId;
        }

        public final void setScanId(String scanId) {
            this.scanId = scanId;
        }

        @Override
        public final Builder scanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getAdminDetectorId() {
            return this.adminDetectorId;
        }

        public final void setAdminDetectorId(String adminDetectorId) {
            this.adminDetectorId = adminDetectorId;
        }

        @Override
        public final Builder adminDetectorId(String adminDetectorId) {
            this.adminDetectorId = adminDetectorId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(MalwareProtectionResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Integer getScannedResourcesCount() {
            return this.scannedResourcesCount;
        }

        public final void setScannedResourcesCount(Integer scannedResourcesCount) {
            this.scannedResourcesCount = scannedResourcesCount;
        }

        @Override
        public final Builder scannedResourcesCount(Integer scannedResourcesCount) {
            this.scannedResourcesCount = scannedResourcesCount;
            return this;
        }

        public final Integer getSkippedResourcesCount() {
            return this.skippedResourcesCount;
        }

        public final void setSkippedResourcesCount(Integer skippedResourcesCount) {
            this.skippedResourcesCount = skippedResourcesCount;
        }

        @Override
        public final Builder skippedResourcesCount(Integer skippedResourcesCount) {
            this.skippedResourcesCount = skippedResourcesCount;
            return this;
        }

        public final Integer getFailedResourcesCount() {
            return this.failedResourcesCount;
        }

        public final void setFailedResourcesCount(Integer failedResourcesCount) {
            this.failedResourcesCount = failedResourcesCount;
        }

        @Override
        public final Builder failedResourcesCount(Integer failedResourcesCount) {
            this.failedResourcesCount = failedResourcesCount;
            return this;
        }

        public final List<ScannedResource.Builder> getScannedResources() {
            List<ScannedResource.Builder> result = ScannedResourcesCopier.copyToBuilder(this.scannedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScannedResources(Collection<ScannedResource.BuilderImpl> scannedResources) {
            this.scannedResources = ScannedResourcesCopier.copyFromBuilder(scannedResources);
        }

        @Override
        public final Builder scannedResources(Collection<ScannedResource> scannedResources) {
            this.scannedResources = ScannedResourcesCopier.copy(scannedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scannedResources(ScannedResource ... scannedResources) {
            this.scannedResources(Arrays.asList(scannedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scannedResources(Consumer<ScannedResource.Builder> ... scannedResources) {
            this.scannedResources(Stream.of(scannedResources).map(c -> (ScannedResource)((ScannedResource.Builder)ScannedResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ScanConfiguration.Builder getScanConfiguration() {
            return this.scanConfiguration != null ? this.scanConfiguration.toBuilder() : null;
        }

        public final void setScanConfiguration(ScanConfiguration.BuilderImpl scanConfiguration) {
            this.scanConfiguration = scanConfiguration != null ? scanConfiguration.build() : null;
        }

        @Override
        public final Builder scanConfiguration(ScanConfiguration scanConfiguration) {
            this.scanConfiguration = scanConfiguration;
            return this;
        }

        public final String getScanCategory() {
            return this.scanCategory;
        }

        public final void setScanCategory(String scanCategory) {
            this.scanCategory = scanCategory;
        }

        @Override
        public final Builder scanCategory(String scanCategory) {
            this.scanCategory = scanCategory;
            return this;
        }

        @Override
        public final Builder scanCategory(ScanCategory scanCategory) {
            this.scanCategory(scanCategory == null ? null : scanCategory.toString());
            return this;
        }

        public final String getScanStatus() {
            return this.scanStatus;
        }

        public final void setScanStatus(String scanStatus) {
            this.scanStatus = scanStatus;
        }

        @Override
        public final Builder scanStatus(String scanStatus) {
            this.scanStatus = scanStatus;
            return this;
        }

        @Override
        public final Builder scanStatus(MalwareProtectionScanStatus scanStatus) {
            this.scanStatus(scanStatus == null ? null : scanStatus.toString());
            return this;
        }

        public final String getScanStatusReason() {
            return this.scanStatusReason;
        }

        public final void setScanStatusReason(String scanStatusReason) {
            this.scanStatusReason = scanStatusReason;
        }

        @Override
        public final Builder scanStatusReason(String scanStatusReason) {
            this.scanStatusReason = scanStatusReason;
            return this;
        }

        @Override
        public final Builder scanStatusReason(ScanStatusReason scanStatusReason) {
            this.scanStatusReason(scanStatusReason == null ? null : scanStatusReason.toString());
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(MalwareProtectionScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final Instant getScanStartedAt() {
            return this.scanStartedAt;
        }

        public final void setScanStartedAt(Instant scanStartedAt) {
            this.scanStartedAt = scanStartedAt;
        }

        @Override
        public final Builder scanStartedAt(Instant scanStartedAt) {
            this.scanStartedAt = scanStartedAt;
            return this;
        }

        public final Instant getScanCompletedAt() {
            return this.scanCompletedAt;
        }

        public final void setScanCompletedAt(Instant scanCompletedAt) {
            this.scanCompletedAt = scanCompletedAt;
        }

        @Override
        public final Builder scanCompletedAt(Instant scanCompletedAt) {
            this.scanCompletedAt = scanCompletedAt;
            return this;
        }

        public final GetMalwareScanResultDetails.Builder getScanResultDetails() {
            return this.scanResultDetails != null ? this.scanResultDetails.toBuilder() : null;
        }

        public final void setScanResultDetails(GetMalwareScanResultDetails.BuilderImpl scanResultDetails) {
            this.scanResultDetails = scanResultDetails != null ? scanResultDetails.build() : null;
        }

        @Override
        public final Builder scanResultDetails(GetMalwareScanResultDetails scanResultDetails) {
            this.scanResultDetails = scanResultDetails;
            return this;
        }

        @Override
        public GetMalwareScanResponse build() {
            return new GetMalwareScanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMalwareScanResponse> {
        public Builder scanId(String var1);

        public Builder detectorId(String var1);

        public Builder adminDetectorId(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(MalwareProtectionResourceType var1);

        public Builder scannedResourcesCount(Integer var1);

        public Builder skippedResourcesCount(Integer var1);

        public Builder failedResourcesCount(Integer var1);

        public Builder scannedResources(Collection<ScannedResource> var1);

        public Builder scannedResources(ScannedResource ... var1);

        public Builder scannedResources(Consumer<ScannedResource.Builder> ... var1);

        public Builder scanConfiguration(ScanConfiguration var1);

        default public Builder scanConfiguration(Consumer<ScanConfiguration.Builder> scanConfiguration) {
            return this.scanConfiguration((ScanConfiguration)((ScanConfiguration.Builder)ScanConfiguration.builder().applyMutation(scanConfiguration)).build());
        }

        public Builder scanCategory(String var1);

        public Builder scanCategory(ScanCategory var1);

        public Builder scanStatus(String var1);

        public Builder scanStatus(MalwareProtectionScanStatus var1);

        public Builder scanStatusReason(String var1);

        public Builder scanStatusReason(ScanStatusReason var1);

        public Builder scanType(String var1);

        public Builder scanType(MalwareProtectionScanType var1);

        public Builder scanStartedAt(Instant var1);

        public Builder scanCompletedAt(Instant var1);

        public Builder scanResultDetails(GetMalwareScanResultDetails var1);

        default public Builder scanResultDetails(Consumer<GetMalwareScanResultDetails.Builder> scanResultDetails) {
            return this.scanResultDetails((GetMalwareScanResultDetails)((GetMalwareScanResultDetails.Builder)GetMalwareScanResultDetails.builder().applyMutation(scanResultDetails)).build());
        }
    }
}

