/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FindingResourceType {
    EC2_INSTANCE("EC2_INSTANCE"),
    EC2_NETWORK_INTERFACE("EC2_NETWORK_INTERFACE"),
    S3_BUCKET("S3_BUCKET"),
    S3_OBJECT("S3_OBJECT"),
    ACCESS_KEY("ACCESS_KEY"),
    EKS_CLUSTER("EKS_CLUSTER"),
    KUBERNETES_WORKLOAD("KUBERNETES_WORKLOAD"),
    CONTAINER("CONTAINER"),
    ECS_CLUSTER("ECS_CLUSTER"),
    ECS_TASK("ECS_TASK"),
    AUTOSCALING_AUTO_SCALING_GROUP("AUTOSCALING_AUTO_SCALING_GROUP"),
    IAM_INSTANCE_PROFILE("IAM_INSTANCE_PROFILE"),
    CLOUDFORMATION_STACK("CLOUDFORMATION_STACK"),
    EC2_LAUNCH_TEMPLATE("EC2_LAUNCH_TEMPLATE"),
    EC2_VPC("EC2_VPC"),
    EC2_IMAGE("EC2_IMAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FindingResourceType> VALUE_MAP;
    private final String value;

    private FindingResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FindingResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FindingResourceType> knownValues() {
        EnumSet<FindingResourceType> knownValues = EnumSet.allOf(FindingResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FindingResourceType.class, FindingResourceType::toString);
    }
}

