/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ContainerUidsCopier;
import software.amazon.awssdk.services.guardduty.model.EcsLaunchType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsTask> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(EcsTask.getter(EcsTask::createdAt)).setter(EcsTask.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskDefinitionArn").getter(EcsTask.getter(EcsTask::taskDefinitionArn)).setter(EcsTask.setter(Builder::taskDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitionArn").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchType").getter(EcsTask.getter(EcsTask::launchTypeAsString)).setter(EcsTask.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<List<String>> CONTAINER_UIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerUids").getter(EcsTask.getter(EcsTask::containerUids)).setter(EcsTask.setter(Builder::containerUids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerUids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, TASK_DEFINITION_ARN_FIELD, LAUNCH_TYPE_FIELD, CONTAINER_UIDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EcsTask.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String taskDefinitionArn;
    private final String launchType;
    private final List<String> containerUids;

    private EcsTask(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.launchType = builder.launchType;
        this.containerUids = builder.containerUids;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String taskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public final EcsLaunchType launchType() {
        return EcsLaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    public final boolean hasContainerUids() {
        return this.containerUids != null && !(this.containerUids instanceof SdkAutoConstructList);
    }

    public final List<String> containerUids() {
        return this.containerUids;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerUids() ? this.containerUids() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsTask)) {
            return false;
        }
        EcsTask other = (EcsTask)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && this.hasContainerUids() == other.hasContainerUids() && Objects.equals(this.containerUids(), other.containerUids());
    }

    public final String toString() {
        return ToString.builder((String)"EcsTask").add("CreatedAt", (Object)this.createdAt()).add("TaskDefinitionArn", (Object)this.taskDefinitionArn()).add("LaunchType", (Object)this.launchTypeAsString()).add("ContainerUids", this.hasContainerUids() ? this.containerUids() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "TaskDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArn()));
            }
            case "LaunchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "ContainerUids": {
                return Optional.ofNullable(clazz.cast(this.containerUids()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("taskDefinitionArn", TASK_DEFINITION_ARN_FIELD);
        map.put("launchType", LAUNCH_TYPE_FIELD);
        map.put("containerUids", CONTAINER_UIDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcsTask, T> g) {
        return obj -> g.apply((EcsTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String taskDefinitionArn;
        private String launchType;
        private List<String> containerUids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EcsTask model) {
            this.createdAt(model.createdAt);
            this.taskDefinitionArn(model.taskDefinitionArn);
            this.launchType(model.launchType);
            this.containerUids(model.containerUids);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(EcsLaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final Collection<String> getContainerUids() {
            if (this.containerUids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerUids;
        }

        public final void setContainerUids(Collection<String> containerUids) {
            this.containerUids = ContainerUidsCopier.copy(containerUids);
        }

        @Override
        public final Builder containerUids(Collection<String> containerUids) {
            this.containerUids = ContainerUidsCopier.copy(containerUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerUids(String ... containerUids) {
            this.containerUids(Arrays.asList(containerUids));
            return this;
        }

        public EcsTask build() {
            return new EcsTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsTask> {
        public Builder createdAt(Instant var1);

        public Builder taskDefinitionArn(String var1);

        public Builder launchType(String var1);

        public Builder launchType(EcsLaunchType var1);

        public Builder containerUids(Collection<String> var1);

        public Builder containerUids(String ... var1);
    }
}

