/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.ListThreatEntitySetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatEntitySetsResponse;

public class ListThreatEntitySetsIterable
implements SdkIterable<ListThreatEntitySetsResponse> {
    private final GuardDutyClient client;
    private final ListThreatEntitySetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThreatEntitySetsIterable(GuardDutyClient client, ListThreatEntitySetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListThreatEntitySetsResponseFetcher();
    }

    public Iterator<ListThreatEntitySetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> threatEntitySetIds() {
        Function<ListThreatEntitySetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.threatEntitySetIds() != null) {
                return response.threatEntitySetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThreatEntitySetsResponseFetcher
    implements SyncPageFetcher<ListThreatEntitySetsResponse> {
        private ListThreatEntitySetsResponseFetcher() {
        }

        public boolean hasNextPage(ListThreatEntitySetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThreatEntitySetsResponse nextPage(ListThreatEntitySetsResponse previousPage) {
            if (previousPage == null) {
                return ListThreatEntitySetsIterable.this.client.listThreatEntitySets(ListThreatEntitySetsIterable.this.firstRequest);
            }
            return ListThreatEntitySetsIterable.this.client.listThreatEntitySets((ListThreatEntitySetsRequest)((Object)ListThreatEntitySetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

