/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrustedEntitySetFormat {
    TXT("TXT"),
    STIX("STIX"),
    OTX_CSV("OTX_CSV"),
    ALIEN_VAULT("ALIEN_VAULT"),
    PROOF_POINT("PROOF_POINT"),
    FIRE_EYE("FIRE_EYE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrustedEntitySetFormat> VALUE_MAP;
    private final String value;

    private TrustedEntitySetFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrustedEntitySetFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrustedEntitySetFormat> knownValues() {
        EnumSet<TrustedEntitySetFormat> knownValues = EnumSet.allOf(TrustedEntitySetFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrustedEntitySetFormat.class, TrustedEntitySetFormat::toString);
    }
}

