/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanType {
    GUARDDUTY_INITIATED("GUARDDUTY_INITIATED"),
    ON_DEMAND("ON_DEMAND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanType> VALUE_MAP;
    private final String value;

    private ScanType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanType> knownValues() {
        EnumSet<ScanType> knownValues = EnumSet.allOf(ScanType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanType.class, ScanType::toString);
    }
}

