/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ContainerUidsCopier;
import software.amazon.awssdk.services.guardduty.model.KubernetesResourcesTypes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KubernetesWorkload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KubernetesWorkload> {
    private static final SdkField<List<String>> CONTAINER_UIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerUids").getter(KubernetesWorkload.getter(KubernetesWorkload::containerUids)).setter(KubernetesWorkload.setter(Builder::containerUids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerUids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(KubernetesWorkload.getter(KubernetesWorkload::namespace)).setter(KubernetesWorkload.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> KUBERNETES_RESOURCES_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KubernetesResourcesTypes").getter(KubernetesWorkload.getter(KubernetesWorkload::kubernetesResourcesTypesAsString)).setter(KubernetesWorkload.setter(Builder::kubernetesResourcesTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_UIDS_FIELD, NAMESPACE_FIELD, KUBERNETES_RESOURCES_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KubernetesWorkload.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> containerUids;
    private final String namespace;
    private final String kubernetesResourcesTypes;

    private KubernetesWorkload(BuilderImpl builder) {
        this.containerUids = builder.containerUids;
        this.namespace = builder.namespace;
        this.kubernetesResourcesTypes = builder.kubernetesResourcesTypes;
    }

    public final boolean hasContainerUids() {
        return this.containerUids != null && !(this.containerUids instanceof SdkAutoConstructList);
    }

    public final List<String> containerUids() {
        return this.containerUids;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final KubernetesResourcesTypes kubernetesResourcesTypes() {
        return KubernetesResourcesTypes.fromValue(this.kubernetesResourcesTypes);
    }

    public final String kubernetesResourcesTypesAsString() {
        return this.kubernetesResourcesTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerUids() ? this.containerUids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesResourcesTypesAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesWorkload)) {
            return false;
        }
        KubernetesWorkload other = (KubernetesWorkload)obj;
        return this.hasContainerUids() == other.hasContainerUids() && Objects.equals(this.containerUids(), other.containerUids()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.kubernetesResourcesTypesAsString(), other.kubernetesResourcesTypesAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KubernetesWorkload").add("ContainerUids", this.hasContainerUids() ? this.containerUids() : null).add("Namespace", (Object)this.namespace()).add("KubernetesResourcesTypes", (Object)this.kubernetesResourcesTypesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerUids": {
                return Optional.ofNullable(clazz.cast(this.containerUids()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "KubernetesResourcesTypes": {
                return Optional.ofNullable(clazz.cast(this.kubernetesResourcesTypesAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("containerUids", CONTAINER_UIDS_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("type", KUBERNETES_RESOURCES_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesWorkload, T> g) {
        return obj -> g.apply((KubernetesWorkload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> containerUids = DefaultSdkAutoConstructList.getInstance();
        private String namespace;
        private String kubernetesResourcesTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesWorkload model) {
            this.containerUids(model.containerUids);
            this.namespace(model.namespace);
            this.kubernetesResourcesTypes(model.kubernetesResourcesTypes);
        }

        public final Collection<String> getContainerUids() {
            if (this.containerUids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerUids;
        }

        public final void setContainerUids(Collection<String> containerUids) {
            this.containerUids = ContainerUidsCopier.copy(containerUids);
        }

        @Override
        public final Builder containerUids(Collection<String> containerUids) {
            this.containerUids = ContainerUidsCopier.copy(containerUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerUids(String ... containerUids) {
            this.containerUids(Arrays.asList(containerUids));
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getKubernetesResourcesTypes() {
            return this.kubernetesResourcesTypes;
        }

        public final void setKubernetesResourcesTypes(String kubernetesResourcesTypes) {
            this.kubernetesResourcesTypes = kubernetesResourcesTypes;
        }

        @Override
        public final Builder kubernetesResourcesTypes(String kubernetesResourcesTypes) {
            this.kubernetesResourcesTypes = kubernetesResourcesTypes;
            return this;
        }

        @Override
        public final Builder kubernetesResourcesTypes(KubernetesResourcesTypes kubernetesResourcesTypes) {
            this.kubernetesResourcesTypes(kubernetesResourcesTypes == null ? null : kubernetesResourcesTypes.toString());
            return this;
        }

        public KubernetesWorkload build() {
            return new KubernetesWorkload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KubernetesWorkload> {
        public Builder containerUids(Collection<String> var1);

        public Builder containerUids(String ... var1);

        public Builder namespace(String var1);

        public Builder kubernetesResourcesTypes(String var1);

        public Builder kubernetesResourcesTypes(KubernetesResourcesTypes var1);
    }
}

