/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KubernetesPermissionCheckedDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KubernetesPermissionCheckedDetails> {
    private static final SdkField<String> VERB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Verb").getter(KubernetesPermissionCheckedDetails.getter(KubernetesPermissionCheckedDetails::verb)).setter(KubernetesPermissionCheckedDetails.setter(Builder::verb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verb").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Resource").getter(KubernetesPermissionCheckedDetails.getter(KubernetesPermissionCheckedDetails::resource)).setter(KubernetesPermissionCheckedDetails.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(KubernetesPermissionCheckedDetails.getter(KubernetesPermissionCheckedDetails::namespace)).setter(KubernetesPermissionCheckedDetails.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<Boolean> ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Allowed").getter(KubernetesPermissionCheckedDetails.getter(KubernetesPermissionCheckedDetails::allowed)).setter(KubernetesPermissionCheckedDetails.setter(Builder::allowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERB_FIELD, RESOURCE_FIELD, NAMESPACE_FIELD, ALLOWED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KubernetesPermissionCheckedDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String verb;
    private final String resource;
    private final String namespace;
    private final Boolean allowed;

    private KubernetesPermissionCheckedDetails(BuilderImpl builder) {
        this.verb = builder.verb;
        this.resource = builder.resource;
        this.namespace = builder.namespace;
        this.allowed = builder.allowed;
    }

    public final String verb() {
        return this.verb;
    }

    public final String resource() {
        return this.resource;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final Boolean allowed() {
        return this.allowed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.verb());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesPermissionCheckedDetails)) {
            return false;
        }
        KubernetesPermissionCheckedDetails other = (KubernetesPermissionCheckedDetails)obj;
        return Objects.equals(this.verb(), other.verb()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.allowed(), other.allowed());
    }

    public final String toString() {
        return ToString.builder((String)"KubernetesPermissionCheckedDetails").add("Verb", (Object)this.verb()).add("Resource", (Object)this.resource()).add("Namespace", (Object)this.namespace()).add("Allowed", (Object)this.allowed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Verb": {
                return Optional.ofNullable(clazz.cast(this.verb()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Allowed": {
                return Optional.ofNullable(clazz.cast(this.allowed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("verb", VERB_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("allowed", ALLOWED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesPermissionCheckedDetails, T> g) {
        return obj -> g.apply((KubernetesPermissionCheckedDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String verb;
        private String resource;
        private String namespace;
        private Boolean allowed;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesPermissionCheckedDetails model) {
            this.verb(model.verb);
            this.resource(model.resource);
            this.namespace(model.namespace);
            this.allowed(model.allowed);
        }

        public final String getVerb() {
            return this.verb;
        }

        public final void setVerb(String verb) {
            this.verb = verb;
        }

        @Override
        public final Builder verb(String verb) {
            this.verb = verb;
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Boolean getAllowed() {
            return this.allowed;
        }

        public final void setAllowed(Boolean allowed) {
            this.allowed = allowed;
        }

        @Override
        public final Builder allowed(Boolean allowed) {
            this.allowed = allowed;
            return this;
        }

        public KubernetesPermissionCheckedDetails build() {
            return new KubernetesPermissionCheckedDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KubernetesPermissionCheckedDetails> {
        public Builder verb(String var1);

        public Builder resource(String var1);

        public Builder namespace(String var1);

        public Builder allowed(Boolean var1);
    }
}

