/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.AccountStatistics;
import software.amazon.awssdk.services.guardduty.model.CountBySeverityCopier;
import software.amazon.awssdk.services.guardduty.model.DateStatistics;
import software.amazon.awssdk.services.guardduty.model.FindingTypeStatistics;
import software.amazon.awssdk.services.guardduty.model.GroupedByAccountCopier;
import software.amazon.awssdk.services.guardduty.model.GroupedByDateCopier;
import software.amazon.awssdk.services.guardduty.model.GroupedByFindingTypeCopier;
import software.amazon.awssdk.services.guardduty.model.GroupedByResourceCopier;
import software.amazon.awssdk.services.guardduty.model.GroupedBySeverityCopier;
import software.amazon.awssdk.services.guardduty.model.ResourceStatistics;
import software.amazon.awssdk.services.guardduty.model.SeverityStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingStatistics> {
    private static final SdkField<Map<String, Integer>> COUNT_BY_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CountBySeverity").getter(FindingStatistics.getter(FindingStatistics::countBySeverity)).setter(FindingStatistics.setter(Builder::countBySeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countBySeverity").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AccountStatistics>> GROUPED_BY_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupedByAccount").getter(FindingStatistics.getter(FindingStatistics::groupedByAccount)).setter(FindingStatistics.setter(Builder::groupedByAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupedByAccount").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DateStatistics>> GROUPED_BY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupedByDate").getter(FindingStatistics.getter(FindingStatistics::groupedByDate)).setter(FindingStatistics.setter(Builder::groupedByDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupedByDate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DateStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FindingTypeStatistics>> GROUPED_BY_FINDING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupedByFindingType").getter(FindingStatistics.getter(FindingStatistics::groupedByFindingType)).setter(FindingStatistics.setter(Builder::groupedByFindingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupedByFindingType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingTypeStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceStatistics>> GROUPED_BY_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupedByResource").getter(FindingStatistics.getter(FindingStatistics::groupedByResource)).setter(FindingStatistics.setter(Builder::groupedByResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupedByResource").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SeverityStatistics>> GROUPED_BY_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupedBySeverity").getter(FindingStatistics.getter(FindingStatistics::groupedBySeverity)).setter(FindingStatistics.setter(Builder::groupedBySeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupedBySeverity").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SeverityStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_BY_SEVERITY_FIELD, GROUPED_BY_ACCOUNT_FIELD, GROUPED_BY_DATE_FIELD, GROUPED_BY_FINDING_TYPE_FIELD, GROUPED_BY_RESOURCE_FIELD, GROUPED_BY_SEVERITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, Integer> countBySeverity;
    private final List<AccountStatistics> groupedByAccount;
    private final List<DateStatistics> groupedByDate;
    private final List<FindingTypeStatistics> groupedByFindingType;
    private final List<ResourceStatistics> groupedByResource;
    private final List<SeverityStatistics> groupedBySeverity;

    private FindingStatistics(BuilderImpl builder) {
        this.countBySeverity = builder.countBySeverity;
        this.groupedByAccount = builder.groupedByAccount;
        this.groupedByDate = builder.groupedByDate;
        this.groupedByFindingType = builder.groupedByFindingType;
        this.groupedByResource = builder.groupedByResource;
        this.groupedBySeverity = builder.groupedBySeverity;
    }

    @Deprecated
    public final boolean hasCountBySeverity() {
        return this.countBySeverity != null && !(this.countBySeverity instanceof SdkAutoConstructMap);
    }

    @Deprecated
    public final Map<String, Integer> countBySeverity() {
        return this.countBySeverity;
    }

    public final boolean hasGroupedByAccount() {
        return this.groupedByAccount != null && !(this.groupedByAccount instanceof SdkAutoConstructList);
    }

    public final List<AccountStatistics> groupedByAccount() {
        return this.groupedByAccount;
    }

    public final boolean hasGroupedByDate() {
        return this.groupedByDate != null && !(this.groupedByDate instanceof SdkAutoConstructList);
    }

    public final List<DateStatistics> groupedByDate() {
        return this.groupedByDate;
    }

    public final boolean hasGroupedByFindingType() {
        return this.groupedByFindingType != null && !(this.groupedByFindingType instanceof SdkAutoConstructList);
    }

    public final List<FindingTypeStatistics> groupedByFindingType() {
        return this.groupedByFindingType;
    }

    public final boolean hasGroupedByResource() {
        return this.groupedByResource != null && !(this.groupedByResource instanceof SdkAutoConstructList);
    }

    public final List<ResourceStatistics> groupedByResource() {
        return this.groupedByResource;
    }

    public final boolean hasGroupedBySeverity() {
        return this.groupedBySeverity != null && !(this.groupedBySeverity instanceof SdkAutoConstructList);
    }

    public final List<SeverityStatistics> groupedBySeverity() {
        return this.groupedBySeverity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountBySeverity() ? this.countBySeverity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupedByAccount() ? this.groupedByAccount() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupedByDate() ? this.groupedByDate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupedByFindingType() ? this.groupedByFindingType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupedByResource() ? this.groupedByResource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupedBySeverity() ? this.groupedBySeverity() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingStatistics)) {
            return false;
        }
        FindingStatistics other = (FindingStatistics)obj;
        return this.hasCountBySeverity() == other.hasCountBySeverity() && Objects.equals(this.countBySeverity(), other.countBySeverity()) && this.hasGroupedByAccount() == other.hasGroupedByAccount() && Objects.equals(this.groupedByAccount(), other.groupedByAccount()) && this.hasGroupedByDate() == other.hasGroupedByDate() && Objects.equals(this.groupedByDate(), other.groupedByDate()) && this.hasGroupedByFindingType() == other.hasGroupedByFindingType() && Objects.equals(this.groupedByFindingType(), other.groupedByFindingType()) && this.hasGroupedByResource() == other.hasGroupedByResource() && Objects.equals(this.groupedByResource(), other.groupedByResource()) && this.hasGroupedBySeverity() == other.hasGroupedBySeverity() && Objects.equals(this.groupedBySeverity(), other.groupedBySeverity());
    }

    public final String toString() {
        return ToString.builder((String)"FindingStatistics").add("CountBySeverity", this.hasCountBySeverity() ? this.countBySeverity() : null).add("GroupedByAccount", this.hasGroupedByAccount() ? this.groupedByAccount() : null).add("GroupedByDate", this.hasGroupedByDate() ? this.groupedByDate() : null).add("GroupedByFindingType", this.hasGroupedByFindingType() ? this.groupedByFindingType() : null).add("GroupedByResource", this.hasGroupedByResource() ? this.groupedByResource() : null).add("GroupedBySeverity", this.hasGroupedBySeverity() ? this.groupedBySeverity() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CountBySeverity": {
                return Optional.ofNullable(clazz.cast(this.countBySeverity()));
            }
            case "GroupedByAccount": {
                return Optional.ofNullable(clazz.cast(this.groupedByAccount()));
            }
            case "GroupedByDate": {
                return Optional.ofNullable(clazz.cast(this.groupedByDate()));
            }
            case "GroupedByFindingType": {
                return Optional.ofNullable(clazz.cast(this.groupedByFindingType()));
            }
            case "GroupedByResource": {
                return Optional.ofNullable(clazz.cast(this.groupedByResource()));
            }
            case "GroupedBySeverity": {
                return Optional.ofNullable(clazz.cast(this.groupedBySeverity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("countBySeverity", COUNT_BY_SEVERITY_FIELD);
        map.put("groupedByAccount", GROUPED_BY_ACCOUNT_FIELD);
        map.put("groupedByDate", GROUPED_BY_DATE_FIELD);
        map.put("groupedByFindingType", GROUPED_BY_FINDING_TYPE_FIELD);
        map.put("groupedByResource", GROUPED_BY_RESOURCE_FIELD);
        map.put("groupedBySeverity", GROUPED_BY_SEVERITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingStatistics, T> g) {
        return obj -> g.apply((FindingStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Integer> countBySeverity = DefaultSdkAutoConstructMap.getInstance();
        private List<AccountStatistics> groupedByAccount = DefaultSdkAutoConstructList.getInstance();
        private List<DateStatistics> groupedByDate = DefaultSdkAutoConstructList.getInstance();
        private List<FindingTypeStatistics> groupedByFindingType = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceStatistics> groupedByResource = DefaultSdkAutoConstructList.getInstance();
        private List<SeverityStatistics> groupedBySeverity = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingStatistics model) {
            this.countBySeverity(model.countBySeverity);
            this.groupedByAccount(model.groupedByAccount);
            this.groupedByDate(model.groupedByDate);
            this.groupedByFindingType(model.groupedByFindingType);
            this.groupedByResource(model.groupedByResource);
            this.groupedBySeverity(model.groupedBySeverity);
        }

        @Deprecated
        public final Map<String, Integer> getCountBySeverity() {
            if (this.countBySeverity instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.countBySeverity;
        }

        @Deprecated
        public final void setCountBySeverity(Map<String, Integer> countBySeverity) {
            this.countBySeverity = CountBySeverityCopier.copy(countBySeverity);
        }

        @Override
        @Deprecated
        public final Builder countBySeverity(Map<String, Integer> countBySeverity) {
            this.countBySeverity = CountBySeverityCopier.copy(countBySeverity);
            return this;
        }

        public final List<AccountStatistics.Builder> getGroupedByAccount() {
            List<AccountStatistics.Builder> result = GroupedByAccountCopier.copyToBuilder(this.groupedByAccount);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedByAccount(Collection<AccountStatistics.BuilderImpl> groupedByAccount) {
            this.groupedByAccount = GroupedByAccountCopier.copyFromBuilder(groupedByAccount);
        }

        @Override
        public final Builder groupedByAccount(Collection<AccountStatistics> groupedByAccount) {
            this.groupedByAccount = GroupedByAccountCopier.copy(groupedByAccount);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByAccount(AccountStatistics ... groupedByAccount) {
            this.groupedByAccount(Arrays.asList(groupedByAccount));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByAccount(Consumer<AccountStatistics.Builder> ... groupedByAccount) {
            this.groupedByAccount(Stream.of(groupedByAccount).map(c -> (AccountStatistics)((AccountStatistics.Builder)AccountStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DateStatistics.Builder> getGroupedByDate() {
            List<DateStatistics.Builder> result = GroupedByDateCopier.copyToBuilder(this.groupedByDate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedByDate(Collection<DateStatistics.BuilderImpl> groupedByDate) {
            this.groupedByDate = GroupedByDateCopier.copyFromBuilder(groupedByDate);
        }

        @Override
        public final Builder groupedByDate(Collection<DateStatistics> groupedByDate) {
            this.groupedByDate = GroupedByDateCopier.copy(groupedByDate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByDate(DateStatistics ... groupedByDate) {
            this.groupedByDate(Arrays.asList(groupedByDate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByDate(Consumer<DateStatistics.Builder> ... groupedByDate) {
            this.groupedByDate(Stream.of(groupedByDate).map(c -> (DateStatistics)((DateStatistics.Builder)DateStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FindingTypeStatistics.Builder> getGroupedByFindingType() {
            List<FindingTypeStatistics.Builder> result = GroupedByFindingTypeCopier.copyToBuilder(this.groupedByFindingType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedByFindingType(Collection<FindingTypeStatistics.BuilderImpl> groupedByFindingType) {
            this.groupedByFindingType = GroupedByFindingTypeCopier.copyFromBuilder(groupedByFindingType);
        }

        @Override
        public final Builder groupedByFindingType(Collection<FindingTypeStatistics> groupedByFindingType) {
            this.groupedByFindingType = GroupedByFindingTypeCopier.copy(groupedByFindingType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByFindingType(FindingTypeStatistics ... groupedByFindingType) {
            this.groupedByFindingType(Arrays.asList(groupedByFindingType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByFindingType(Consumer<FindingTypeStatistics.Builder> ... groupedByFindingType) {
            this.groupedByFindingType(Stream.of(groupedByFindingType).map(c -> (FindingTypeStatistics)((FindingTypeStatistics.Builder)FindingTypeStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStatistics.Builder> getGroupedByResource() {
            List<ResourceStatistics.Builder> result = GroupedByResourceCopier.copyToBuilder(this.groupedByResource);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedByResource(Collection<ResourceStatistics.BuilderImpl> groupedByResource) {
            this.groupedByResource = GroupedByResourceCopier.copyFromBuilder(groupedByResource);
        }

        @Override
        public final Builder groupedByResource(Collection<ResourceStatistics> groupedByResource) {
            this.groupedByResource = GroupedByResourceCopier.copy(groupedByResource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByResource(ResourceStatistics ... groupedByResource) {
            this.groupedByResource(Arrays.asList(groupedByResource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByResource(Consumer<ResourceStatistics.Builder> ... groupedByResource) {
            this.groupedByResource(Stream.of(groupedByResource).map(c -> (ResourceStatistics)((ResourceStatistics.Builder)ResourceStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SeverityStatistics.Builder> getGroupedBySeverity() {
            List<SeverityStatistics.Builder> result = GroupedBySeverityCopier.copyToBuilder(this.groupedBySeverity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedBySeverity(Collection<SeverityStatistics.BuilderImpl> groupedBySeverity) {
            this.groupedBySeverity = GroupedBySeverityCopier.copyFromBuilder(groupedBySeverity);
        }

        @Override
        public final Builder groupedBySeverity(Collection<SeverityStatistics> groupedBySeverity) {
            this.groupedBySeverity = GroupedBySeverityCopier.copy(groupedBySeverity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedBySeverity(SeverityStatistics ... groupedBySeverity) {
            this.groupedBySeverity(Arrays.asList(groupedBySeverity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedBySeverity(Consumer<SeverityStatistics.Builder> ... groupedBySeverity) {
            this.groupedBySeverity(Stream.of(groupedBySeverity).map(c -> (SeverityStatistics)((SeverityStatistics.Builder)SeverityStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FindingStatistics build() {
            return new FindingStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingStatistics> {
        @Deprecated
        public Builder countBySeverity(Map<String, Integer> var1);

        public Builder groupedByAccount(Collection<AccountStatistics> var1);

        public Builder groupedByAccount(AccountStatistics ... var1);

        public Builder groupedByAccount(Consumer<AccountStatistics.Builder> ... var1);

        public Builder groupedByDate(Collection<DateStatistics> var1);

        public Builder groupedByDate(DateStatistics ... var1);

        public Builder groupedByDate(Consumer<DateStatistics.Builder> ... var1);

        public Builder groupedByFindingType(Collection<FindingTypeStatistics> var1);

        public Builder groupedByFindingType(FindingTypeStatistics ... var1);

        public Builder groupedByFindingType(Consumer<FindingTypeStatistics.Builder> ... var1);

        public Builder groupedByResource(Collection<ResourceStatistics> var1);

        public Builder groupedByResource(ResourceStatistics ... var1);

        public Builder groupedByResource(Consumer<ResourceStatistics.Builder> ... var1);

        public Builder groupedBySeverity(Collection<SeverityStatistics> var1);

        public Builder groupedBySeverity(SeverityStatistics ... var1);

        public Builder groupedBySeverity(Consumer<SeverityStatistics.Builder> ... var1);
    }
}

