/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse;

public class ListDetectorsIterable
implements SdkIterable<ListDetectorsResponse> {
    private final GuardDutyClient client;
    private final ListDetectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDetectorsIterable(GuardDutyClient client, ListDetectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDetectorsResponseFetcher();
    }

    public Iterator<ListDetectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> detectorIds() {
        Function<ListDetectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.detectorIds() != null) {
                return response.detectorIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDetectorsResponseFetcher
    implements SyncPageFetcher<ListDetectorsResponse> {
        private ListDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDetectorsResponse nextPage(ListDetectorsResponse previousPage) {
            if (previousPage == null) {
                return ListDetectorsIterable.this.client.listDetectors(ListDetectorsIterable.this.firstRequest);
            }
            return ListDetectorsIterable.this.client.listDetectors((ListDetectorsRequest)((Object)ListDetectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

