/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.EphemerisStatus;
import software.amazon.awssdk.services.groundstation.model.EphemerisStatusListCopier;
import software.amazon.awssdk.services.groundstation.model.EphemerisType;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEphemeridesRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, ListEphemeridesRequest> {
    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteId").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::satelliteId)).setter(ListEphemeridesRequest.setter(Builder::satelliteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()}).build();
    private static final SdkField<String> EPHEMERIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ephemerisType").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::ephemerisTypeAsString)).setter(ListEphemeridesRequest.setter(Builder::ephemerisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::startTime)).setter(ListEphemeridesRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::endTime)).setter(ListEphemeridesRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<List<String>> STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusList").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::statusListAsStrings)).setter(ListEphemeridesRequest.setter(Builder::statusListWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::maxResults)).setter(ListEphemeridesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::nextToken)).setter(ListEphemeridesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SATELLITE_ID_FIELD, EPHEMERIS_TYPE_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_LIST_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEphemeridesRequest.memberNameToFieldInitializer();
    private final String satelliteId;
    private final String ephemerisType;
    private final Instant startTime;
    private final Instant endTime;
    private final List<String> statusList;
    private final Integer maxResults;
    private final String nextToken;

    private ListEphemeridesRequest(BuilderImpl builder) {
        super(builder);
        this.satelliteId = builder.satelliteId;
        this.ephemerisType = builder.ephemerisType;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.statusList = builder.statusList;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String satelliteId() {
        return this.satelliteId;
    }

    public final EphemerisType ephemerisType() {
        return EphemerisType.fromValue(this.ephemerisType);
    }

    public final String ephemerisTypeAsString() {
        return this.ephemerisType;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final List<EphemerisStatus> statusList() {
        return EphemerisStatusListCopier.copyStringToEnum(this.statusList);
    }

    public final boolean hasStatusList() {
        return this.statusList != null && !(this.statusList instanceof SdkAutoConstructList);
    }

    public final List<String> statusListAsStrings() {
        return this.statusList;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemerisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusList() ? this.statusListAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEphemeridesRequest)) {
            return false;
        }
        ListEphemeridesRequest other = (ListEphemeridesRequest)((Object)obj);
        return Objects.equals(this.satelliteId(), other.satelliteId()) && Objects.equals(this.ephemerisTypeAsString(), other.ephemerisTypeAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasStatusList() == other.hasStatusList() && Objects.equals(this.statusListAsStrings(), other.statusListAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEphemeridesRequest").add("SatelliteId", (Object)this.satelliteId()).add("EphemerisType", (Object)this.ephemerisTypeAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("StatusList", this.hasStatusList() ? this.statusListAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "satelliteId": {
                return Optional.ofNullable(clazz.cast(this.satelliteId()));
            }
            case "ephemerisType": {
                return Optional.ofNullable(clazz.cast(this.ephemerisTypeAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "statusList": {
                return Optional.ofNullable(clazz.cast(this.statusListAsStrings()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("satelliteId", SATELLITE_ID_FIELD);
        map.put("ephemerisType", EPHEMERIS_TYPE_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("statusList", STATUS_LIST_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEphemeridesRequest, T> g) {
        return obj -> g.apply((ListEphemeridesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private String satelliteId;
        private String ephemerisType;
        private Instant startTime;
        private Instant endTime;
        private List<String> statusList = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEphemeridesRequest model) {
            super(model);
            this.satelliteId(model.satelliteId);
            this.ephemerisType(model.ephemerisType);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.statusListWithStrings(model.statusList);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getSatelliteId() {
            return this.satelliteId;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final String getEphemerisType() {
            return this.ephemerisType;
        }

        public final void setEphemerisType(String ephemerisType) {
            this.ephemerisType = ephemerisType;
        }

        @Override
        public final Builder ephemerisType(String ephemerisType) {
            this.ephemerisType = ephemerisType;
            return this;
        }

        @Override
        public final Builder ephemerisType(EphemerisType ephemerisType) {
            this.ephemerisType(ephemerisType == null ? null : ephemerisType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<String> getStatusList() {
            if (this.statusList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusList;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = EphemerisStatusListCopier.copy(statusList);
        }

        @Override
        public final Builder statusListWithStrings(Collection<String> statusList) {
            this.statusList = EphemerisStatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusListWithStrings(String ... statusList) {
            this.statusListWithStrings(Arrays.asList(statusList));
            return this;
        }

        @Override
        public final Builder statusList(Collection<EphemerisStatus> statusList) {
            this.statusList = EphemerisStatusListCopier.copyEnumToString(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(EphemerisStatus ... statusList) {
            this.statusList(Arrays.asList(statusList));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEphemeridesRequest build() {
            return new ListEphemeridesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEphemeridesRequest> {
        public Builder satelliteId(String var1);

        public Builder ephemerisType(String var1);

        public Builder ephemerisType(EphemerisType var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder statusListWithStrings(Collection<String> var1);

        public Builder statusListWithStrings(String ... var1);

        public Builder statusList(Collection<EphemerisStatus> var1);

        public Builder statusList(EphemerisStatus ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

