/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.ISO8601TimeRange;
import software.amazon.awssdk.services.groundstation.model.TimeAzEl;
import software.amazon.awssdk.services.groundstation.model.TimeAzElListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AzElSegment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AzElSegment> {
    private static final SdkField<Instant> REFERENCE_EPOCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("referenceEpoch").getter(AzElSegment.getter(AzElSegment::referenceEpoch)).setter(AzElSegment.setter(Builder::referenceEpoch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceEpoch").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ISO8601TimeRange> VALID_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validTimeRange").getter(AzElSegment.getter(AzElSegment::validTimeRange)).setter(AzElSegment.setter(Builder::validTimeRange)).constructor(ISO8601TimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validTimeRange").build()}).build();
    private static final SdkField<List<TimeAzEl>> AZ_EL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("azElList").getter(AzElSegment.getter(AzElSegment::azElList)).setter(AzElSegment.setter(Builder::azElList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azElList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeAzEl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_EPOCH_FIELD, VALID_TIME_RANGE_FIELD, AZ_EL_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AzElSegment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant referenceEpoch;
    private final ISO8601TimeRange validTimeRange;
    private final List<TimeAzEl> azElList;

    private AzElSegment(BuilderImpl builder) {
        this.referenceEpoch = builder.referenceEpoch;
        this.validTimeRange = builder.validTimeRange;
        this.azElList = builder.azElList;
    }

    public final Instant referenceEpoch() {
        return this.referenceEpoch;
    }

    public final ISO8601TimeRange validTimeRange() {
        return this.validTimeRange;
    }

    public final boolean hasAzElList() {
        return this.azElList != null && !(this.azElList instanceof SdkAutoConstructList);
    }

    public final List<TimeAzEl> azElList() {
        return this.azElList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceEpoch());
        hashCode = 31 * hashCode + Objects.hashCode(this.validTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAzElList() ? this.azElList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AzElSegment)) {
            return false;
        }
        AzElSegment other = (AzElSegment)obj;
        return Objects.equals(this.referenceEpoch(), other.referenceEpoch()) && Objects.equals(this.validTimeRange(), other.validTimeRange()) && this.hasAzElList() == other.hasAzElList() && Objects.equals(this.azElList(), other.azElList());
    }

    public final String toString() {
        return ToString.builder((String)"AzElSegment").add("ReferenceEpoch", (Object)this.referenceEpoch()).add("ValidTimeRange", (Object)this.validTimeRange()).add("AzElList", this.hasAzElList() ? this.azElList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "referenceEpoch": {
                return Optional.ofNullable(clazz.cast(this.referenceEpoch()));
            }
            case "validTimeRange": {
                return Optional.ofNullable(clazz.cast(this.validTimeRange()));
            }
            case "azElList": {
                return Optional.ofNullable(clazz.cast(this.azElList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("referenceEpoch", REFERENCE_EPOCH_FIELD);
        map.put("validTimeRange", VALID_TIME_RANGE_FIELD);
        map.put("azElList", AZ_EL_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AzElSegment, T> g) {
        return obj -> g.apply((AzElSegment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant referenceEpoch;
        private ISO8601TimeRange validTimeRange;
        private List<TimeAzEl> azElList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AzElSegment model) {
            this.referenceEpoch(model.referenceEpoch);
            this.validTimeRange(model.validTimeRange);
            this.azElList(model.azElList);
        }

        public final Instant getReferenceEpoch() {
            return this.referenceEpoch;
        }

        public final void setReferenceEpoch(Instant referenceEpoch) {
            this.referenceEpoch = referenceEpoch;
        }

        @Override
        public final Builder referenceEpoch(Instant referenceEpoch) {
            this.referenceEpoch = referenceEpoch;
            return this;
        }

        public final ISO8601TimeRange.Builder getValidTimeRange() {
            return this.validTimeRange != null ? this.validTimeRange.toBuilder() : null;
        }

        public final void setValidTimeRange(ISO8601TimeRange.BuilderImpl validTimeRange) {
            this.validTimeRange = validTimeRange != null ? validTimeRange.build() : null;
        }

        @Override
        public final Builder validTimeRange(ISO8601TimeRange validTimeRange) {
            this.validTimeRange = validTimeRange;
            return this;
        }

        public final List<TimeAzEl.Builder> getAzElList() {
            List<TimeAzEl.Builder> result = TimeAzElListCopier.copyToBuilder(this.azElList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAzElList(Collection<TimeAzEl.BuilderImpl> azElList) {
            this.azElList = TimeAzElListCopier.copyFromBuilder(azElList);
        }

        @Override
        public final Builder azElList(Collection<TimeAzEl> azElList) {
            this.azElList = TimeAzElListCopier.copy(azElList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder azElList(TimeAzEl ... azElList) {
            this.azElList(Arrays.asList(azElList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder azElList(Consumer<TimeAzEl.Builder> ... azElList) {
            this.azElList(Stream.of(azElList).map(c -> (TimeAzEl)((TimeAzEl.Builder)TimeAzEl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AzElSegment build() {
            return new AzElSegment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AzElSegment> {
        public Builder referenceEpoch(Instant var1);

        public Builder validTimeRange(ISO8601TimeRange var1);

        default public Builder validTimeRange(Consumer<ISO8601TimeRange.Builder> validTimeRange) {
            return this.validTimeRange((ISO8601TimeRange)((ISO8601TimeRange.Builder)ISO8601TimeRange.builder().applyMutation(validTimeRange)).build());
        }

        public Builder azElList(Collection<TimeAzEl> var1);

        public Builder azElList(TimeAzEl ... var1);

        public Builder azElList(Consumer<TimeAzEl.Builder> ... var1);
    }
}

