/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.CreateEndpointDetails;
import software.amazon.awssdk.services.groundstation.model.CreateEndpointDetailsListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataflowEndpointGroupV2Request
extends GroundStationRequest
implements ToCopyableBuilder<Builder, CreateDataflowEndpointGroupV2Request> {
    private static final SdkField<List<CreateEndpointDetails>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("endpoints").getter(CreateDataflowEndpointGroupV2Request.getter(CreateDataflowEndpointGroupV2Request::endpoints)).setter(CreateDataflowEndpointGroupV2Request.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateEndpointDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CONTACT_PRE_PASS_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("contactPrePassDurationSeconds").getter(CreateDataflowEndpointGroupV2Request.getter(CreateDataflowEndpointGroupV2Request::contactPrePassDurationSeconds)).setter(CreateDataflowEndpointGroupV2Request.setter(Builder::contactPrePassDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPrePassDurationSeconds").build()}).build();
    private static final SdkField<Integer> CONTACT_POST_PASS_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("contactPostPassDurationSeconds").getter(CreateDataflowEndpointGroupV2Request.getter(CreateDataflowEndpointGroupV2Request::contactPostPassDurationSeconds)).setter(CreateDataflowEndpointGroupV2Request.setter(Builder::contactPostPassDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPostPassDurationSeconds").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDataflowEndpointGroupV2Request.getter(CreateDataflowEndpointGroupV2Request::tags)).setter(CreateDataflowEndpointGroupV2Request.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINTS_FIELD, CONTACT_PRE_PASS_DURATION_SECONDS_FIELD, CONTACT_POST_PASS_DURATION_SECONDS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataflowEndpointGroupV2Request.memberNameToFieldInitializer();
    private final List<CreateEndpointDetails> endpoints;
    private final Integer contactPrePassDurationSeconds;
    private final Integer contactPostPassDurationSeconds;
    private final Map<String, String> tags;

    private CreateDataflowEndpointGroupV2Request(BuilderImpl builder) {
        super(builder);
        this.endpoints = builder.endpoints;
        this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
        this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
        this.tags = builder.tags;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<CreateEndpointDetails> endpoints() {
        return this.endpoints;
    }

    public final Integer contactPrePassDurationSeconds() {
        return this.contactPrePassDurationSeconds;
    }

    public final Integer contactPostPassDurationSeconds() {
        return this.contactPostPassDurationSeconds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contactPrePassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactPostPassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataflowEndpointGroupV2Request)) {
            return false;
        }
        CreateDataflowEndpointGroupV2Request other = (CreateDataflowEndpointGroupV2Request)((Object)obj);
        return this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.contactPrePassDurationSeconds(), other.contactPrePassDurationSeconds()) && Objects.equals(this.contactPostPassDurationSeconds(), other.contactPostPassDurationSeconds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataflowEndpointGroupV2Request").add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("ContactPrePassDurationSeconds", (Object)this.contactPrePassDurationSeconds()).add("ContactPostPassDurationSeconds", (Object)this.contactPostPassDurationSeconds()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "contactPrePassDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.contactPrePassDurationSeconds()));
            }
            case "contactPostPassDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.contactPostPassDurationSeconds()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endpoints", ENDPOINTS_FIELD);
        map.put("contactPrePassDurationSeconds", CONTACT_PRE_PASS_DURATION_SECONDS_FIELD);
        map.put("contactPostPassDurationSeconds", CONTACT_POST_PASS_DURATION_SECONDS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataflowEndpointGroupV2Request, T> g) {
        return obj -> g.apply((CreateDataflowEndpointGroupV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private List<CreateEndpointDetails> endpoints = DefaultSdkAutoConstructList.getInstance();
        private Integer contactPrePassDurationSeconds;
        private Integer contactPostPassDurationSeconds;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataflowEndpointGroupV2Request model) {
            super(model);
            this.endpoints(model.endpoints);
            this.contactPrePassDurationSeconds(model.contactPrePassDurationSeconds);
            this.contactPostPassDurationSeconds(model.contactPostPassDurationSeconds);
            this.tags(model.tags);
        }

        public final List<CreateEndpointDetails.Builder> getEndpoints() {
            List<CreateEndpointDetails.Builder> result = CreateEndpointDetailsListCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<CreateEndpointDetails.BuilderImpl> endpoints) {
            this.endpoints = CreateEndpointDetailsListCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<CreateEndpointDetails> endpoints) {
            this.endpoints = CreateEndpointDetailsListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(CreateEndpointDetails ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<CreateEndpointDetails.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (CreateEndpointDetails)((CreateEndpointDetails.Builder)CreateEndpointDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getContactPrePassDurationSeconds() {
            return this.contactPrePassDurationSeconds;
        }

        public final void setContactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
        }

        @Override
        public final Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        public final Integer getContactPostPassDurationSeconds() {
            return this.contactPostPassDurationSeconds;
        }

        public final void setContactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
        }

        @Override
        public final Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataflowEndpointGroupV2Request build() {
            return new CreateDataflowEndpointGroupV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataflowEndpointGroupV2Request> {
        public Builder endpoints(Collection<CreateEndpointDetails> var1);

        public Builder endpoints(CreateEndpointDetails ... var1);

        public Builder endpoints(Consumer<CreateEndpointDetails.Builder> ... var1);

        public Builder contactPrePassDurationSeconds(Integer var1);

        public Builder contactPostPassDurationSeconds(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

