/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.AzElSegments;
import software.amazon.awssdk.services.groundstation.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AzElSegmentsData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AzElSegmentsData> {
    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Object").getter(AzElSegmentsData.getter(AzElSegmentsData::s3Object)).setter(AzElSegmentsData.setter(Builder::s3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Object").build()}).build();
    private static final SdkField<AzElSegments> AZ_EL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("azElData").getter(AzElSegmentsData.getter(AzElSegmentsData::azElData)).setter(AzElSegmentsData.setter(Builder::azElData)).constructor(AzElSegments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azElData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OBJECT_FIELD, AZ_EL_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AzElSegmentsData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Object s3Object;
    private final AzElSegments azElData;
    private final Type type;

    private AzElSegmentsData(BuilderImpl builder) {
        this.s3Object = builder.s3Object;
        this.azElData = builder.azElData;
        this.type = builder.type;
    }

    public final S3Object s3Object() {
        return this.s3Object;
    }

    public final AzElSegments azElData() {
        return this.azElData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Object());
        hashCode = 31 * hashCode + Objects.hashCode(this.azElData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AzElSegmentsData)) {
            return false;
        }
        AzElSegmentsData other = (AzElSegmentsData)obj;
        return Objects.equals(this.s3Object(), other.s3Object()) && Objects.equals(this.azElData(), other.azElData());
    }

    public final String toString() {
        return ToString.builder((String)"AzElSegmentsData").add("S3Object", (Object)this.s3Object()).add("AzElData", (Object)this.azElData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Object": {
                return Optional.ofNullable(clazz.cast(this.s3Object()));
            }
            case "azElData": {
                return Optional.ofNullable(clazz.cast(this.azElData()));
            }
        }
        return Optional.empty();
    }

    public static AzElSegmentsData fromS3Object(S3Object s3Object) {
        return (AzElSegmentsData)AzElSegmentsData.builder().s3Object(s3Object).build();
    }

    public static AzElSegmentsData fromS3Object(Consumer<S3Object.Builder> s3Object) {
        S3Object.Builder builder = S3Object.builder();
        s3Object.accept(builder);
        return AzElSegmentsData.fromS3Object((S3Object)builder.build());
    }

    public static AzElSegmentsData fromAzElData(AzElSegments azElData) {
        return (AzElSegmentsData)AzElSegmentsData.builder().azElData(azElData).build();
    }

    public static AzElSegmentsData fromAzElData(Consumer<AzElSegments.Builder> azElData) {
        AzElSegments.Builder builder = AzElSegments.builder();
        azElData.accept(builder);
        return AzElSegmentsData.fromAzElData((AzElSegments)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3Object", S3_OBJECT_FIELD);
        map.put("azElData", AZ_EL_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AzElSegmentsData, T> g) {
        return obj -> g.apply((AzElSegmentsData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3_OBJECT,
        AZ_EL_DATA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private S3Object s3Object;
        private AzElSegments azElData;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AzElSegmentsData model) {
            this.s3Object(model.s3Object);
            this.azElData(model.azElData);
        }

        public final S3Object.Builder getS3Object() {
            return this.s3Object != null ? this.s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            S3Object oldValue = this.s3Object;
            this.s3Object = s3Object != null ? s3Object.build() : null;
            this.handleUnionValueChange(Type.S3_OBJECT, oldValue, this.s3Object);
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            S3Object oldValue = this.s3Object;
            this.s3Object = s3Object;
            this.handleUnionValueChange(Type.S3_OBJECT, oldValue, this.s3Object);
            return this;
        }

        public final AzElSegments.Builder getAzElData() {
            return this.azElData != null ? this.azElData.toBuilder() : null;
        }

        public final void setAzElData(AzElSegments.BuilderImpl azElData) {
            AzElSegments oldValue = this.azElData;
            this.azElData = azElData != null ? azElData.build() : null;
            this.handleUnionValueChange(Type.AZ_EL_DATA, oldValue, this.azElData);
        }

        @Override
        public final Builder azElData(AzElSegments azElData) {
            AzElSegments oldValue = this.azElData;
            this.azElData = azElData;
            this.handleUnionValueChange(Type.AZ_EL_DATA, oldValue, this.azElData);
            return this;
        }

        public AzElSegmentsData build() {
            return new AzElSegmentsData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AzElSegmentsData> {
        public Builder s3Object(S3Object var1);

        default public Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return this.s3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(s3Object)).build());
        }

        public Builder azElData(AzElSegments var1);

        default public Builder azElData(Consumer<AzElSegments.Builder> azElData) {
            return this.azElData((AzElSegments)((AzElSegments.Builder)AzElSegments.builder().applyMutation(azElData)).build());
        }
    }
}

