/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType;
import software.amazon.awssdk.services.groundstation.model.ConfigTypeData;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, GetConfigResponse> {
    private static final SdkField<String> CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configArn").getter(GetConfigResponse.getter(GetConfigResponse::configArn)).setter(GetConfigResponse.setter(Builder::configArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configArn").build()}).build();
    private static final SdkField<ConfigTypeData> CONFIG_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configData").getter(GetConfigResponse.getter(GetConfigResponse::configData)).setter(GetConfigResponse.setter(Builder::configData)).constructor(ConfigTypeData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configData").build()}).build();
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configId").getter(GetConfigResponse.getter(GetConfigResponse::configId)).setter(GetConfigResponse.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()}).build();
    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configType").getter(GetConfigResponse.getter(GetConfigResponse::configTypeAsString)).setter(GetConfigResponse.setter(Builder::configType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetConfigResponse.getter(GetConfigResponse::name)).setter(GetConfigResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetConfigResponse.getter(GetConfigResponse::tags)).setter(GetConfigResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ARN_FIELD, CONFIG_DATA_FIELD, CONFIG_ID_FIELD, CONFIG_TYPE_FIELD, NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConfigResponse.memberNameToFieldInitializer();
    private final String configArn;
    private final ConfigTypeData configData;
    private final String configId;
    private final String configType;
    private final String name;
    private final Map<String, String> tags;

    private GetConfigResponse(BuilderImpl builder) {
        super(builder);
        this.configArn = builder.configArn;
        this.configData = builder.configData;
        this.configId = builder.configId;
        this.configType = builder.configType;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final String configArn() {
        return this.configArn;
    }

    public final ConfigTypeData configData() {
        return this.configData;
    }

    public final String configId() {
        return this.configId;
    }

    public final ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(this.configType);
    }

    public final String configTypeAsString() {
        return this.configType;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configData());
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigResponse)) {
            return false;
        }
        GetConfigResponse other = (GetConfigResponse)((Object)obj);
        return Objects.equals(this.configArn(), other.configArn()) && Objects.equals(this.configData(), other.configData()) && Objects.equals(this.configId(), other.configId()) && Objects.equals(this.configTypeAsString(), other.configTypeAsString()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetConfigResponse").add("ConfigArn", (Object)this.configArn()).add("ConfigData", (Object)this.configData()).add("ConfigId", (Object)this.configId()).add("ConfigType", (Object)this.configTypeAsString()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configArn": {
                return Optional.ofNullable(clazz.cast(this.configArn()));
            }
            case "configData": {
                return Optional.ofNullable(clazz.cast(this.configData()));
            }
            case "configId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "configType": {
                return Optional.ofNullable(clazz.cast(this.configTypeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configArn", CONFIG_ARN_FIELD);
        map.put("configData", CONFIG_DATA_FIELD);
        map.put("configId", CONFIG_ID_FIELD);
        map.put("configType", CONFIG_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfigResponse, T> g) {
        return obj -> g.apply((GetConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String configArn;
        private ConfigTypeData configData;
        private String configId;
        private String configType;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigResponse model) {
            super(model);
            this.configArn(model.configArn);
            this.configData(model.configData);
            this.configId(model.configId);
            this.configType(model.configType);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final String getConfigArn() {
            return this.configArn;
        }

        public final void setConfigArn(String configArn) {
            this.configArn = configArn;
        }

        @Override
        public final Builder configArn(String configArn) {
            this.configArn = configArn;
            return this;
        }

        public final ConfigTypeData.Builder getConfigData() {
            return this.configData != null ? this.configData.toBuilder() : null;
        }

        public final void setConfigData(ConfigTypeData.BuilderImpl configData) {
            this.configData = configData != null ? configData.build() : null;
        }

        @Override
        public final Builder configData(ConfigTypeData configData) {
            this.configData = configData;
            return this;
        }

        public final String getConfigId() {
            return this.configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getConfigType() {
            return this.configType;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetConfigResponse build() {
            return new GetConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigResponse> {
        public Builder configArn(String var1);

        public Builder configData(ConfigTypeData var1);

        default public Builder configData(Consumer<ConfigTypeData.Builder> configData) {
            return this.configData((ConfigTypeData)((ConfigTypeData.Builder)ConfigTypeData.builder().applyMutation(configData)).build());
        }

        public Builder configId(String var1);

        public Builder configType(String var1);

        public Builder configType(ConfigCapabilityType var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

