/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CapabilityHealthReason {
    NO_REGISTERED_AGENT("NO_REGISTERED_AGENT"),
    INVALID_IP_OWNERSHIP("INVALID_IP_OWNERSHIP"),
    NOT_AUTHORIZED_TO_CREATE_SLR("NOT_AUTHORIZED_TO_CREATE_SLR"),
    UNVERIFIED_IP_OWNERSHIP("UNVERIFIED_IP_OWNERSHIP"),
    INITIALIZING_DATAPLANE("INITIALIZING_DATAPLANE"),
    DATAPLANE_FAILURE("DATAPLANE_FAILURE"),
    HEALTHY("HEALTHY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapabilityHealthReason> VALUE_MAP;
    private final String value;

    private CapabilityHealthReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CapabilityHealthReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CapabilityHealthReason> knownValues() {
        EnumSet<CapabilityHealthReason> knownValues = EnumSet.allOf(CapabilityHealthReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CapabilityHealthReason.class, CapabilityHealthReason::toString);
    }
}

