/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.EphemerisMetaData;
import software.amazon.awssdk.services.groundstation.model.GroundStationIdListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSatelliteResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, GetSatelliteResponse> {
    private static final SdkField<EphemerisMetaData> CURRENT_EPHEMERIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentEphemeris").getter(GetSatelliteResponse.getter(GetSatelliteResponse::currentEphemeris)).setter(GetSatelliteResponse.setter(Builder::currentEphemeris)).constructor(EphemerisMetaData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentEphemeris").build()}).build();
    private static final SdkField<List<String>> GROUND_STATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groundStations").getter(GetSatelliteResponse.getter(GetSatelliteResponse::groundStations)).setter(GetSatelliteResponse.setter(Builder::groundStations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NORAD_SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("noradSatelliteID").getter(GetSatelliteResponse.getter(GetSatelliteResponse::noradSatelliteID)).setter(GetSatelliteResponse.setter(Builder::noradSatelliteID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noradSatelliteID").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteArn").getter(GetSatelliteResponse.getter(GetSatelliteResponse::satelliteArn)).setter(GetSatelliteResponse.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteId").getter(GetSatelliteResponse.getter(GetSatelliteResponse::satelliteId)).setter(GetSatelliteResponse.setter(Builder::satelliteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_EPHEMERIS_FIELD, GROUND_STATIONS_FIELD, NORAD_SATELLITE_ID_FIELD, SATELLITE_ARN_FIELD, SATELLITE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSatelliteResponse.memberNameToFieldInitializer();
    private final EphemerisMetaData currentEphemeris;
    private final List<String> groundStations;
    private final Integer noradSatelliteID;
    private final String satelliteArn;
    private final String satelliteId;

    private GetSatelliteResponse(BuilderImpl builder) {
        super(builder);
        this.currentEphemeris = builder.currentEphemeris;
        this.groundStations = builder.groundStations;
        this.noradSatelliteID = builder.noradSatelliteID;
        this.satelliteArn = builder.satelliteArn;
        this.satelliteId = builder.satelliteId;
    }

    public final EphemerisMetaData currentEphemeris() {
        return this.currentEphemeris;
    }

    public final boolean hasGroundStations() {
        return this.groundStations != null && !(this.groundStations instanceof SdkAutoConstructList);
    }

    public final List<String> groundStations() {
        return this.groundStations;
    }

    public final Integer noradSatelliteID() {
        return this.noradSatelliteID;
    }

    public final String satelliteArn() {
        return this.satelliteArn;
    }

    public final String satelliteId() {
        return this.satelliteId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.currentEphemeris());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroundStations() ? this.groundStations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.noradSatelliteID());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSatelliteResponse)) {
            return false;
        }
        GetSatelliteResponse other = (GetSatelliteResponse)((Object)obj);
        return Objects.equals(this.currentEphemeris(), other.currentEphemeris()) && this.hasGroundStations() == other.hasGroundStations() && Objects.equals(this.groundStations(), other.groundStations()) && Objects.equals(this.noradSatelliteID(), other.noradSatelliteID()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.satelliteId(), other.satelliteId());
    }

    public final String toString() {
        return ToString.builder((String)"GetSatelliteResponse").add("CurrentEphemeris", (Object)this.currentEphemeris()).add("GroundStations", this.hasGroundStations() ? this.groundStations() : null).add("NoradSatelliteID", (Object)this.noradSatelliteID()).add("SatelliteArn", (Object)this.satelliteArn()).add("SatelliteId", (Object)this.satelliteId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currentEphemeris": {
                return Optional.ofNullable(clazz.cast(this.currentEphemeris()));
            }
            case "groundStations": {
                return Optional.ofNullable(clazz.cast(this.groundStations()));
            }
            case "noradSatelliteID": {
                return Optional.ofNullable(clazz.cast(this.noradSatelliteID()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "satelliteId": {
                return Optional.ofNullable(clazz.cast(this.satelliteId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currentEphemeris", CURRENT_EPHEMERIS_FIELD);
        map.put("groundStations", GROUND_STATIONS_FIELD);
        map.put("noradSatelliteID", NORAD_SATELLITE_ID_FIELD);
        map.put("satelliteArn", SATELLITE_ARN_FIELD);
        map.put("satelliteId", SATELLITE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSatelliteResponse, T> g) {
        return obj -> g.apply((GetSatelliteResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private EphemerisMetaData currentEphemeris;
        private List<String> groundStations = DefaultSdkAutoConstructList.getInstance();
        private Integer noradSatelliteID;
        private String satelliteArn;
        private String satelliteId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSatelliteResponse model) {
            super(model);
            this.currentEphemeris(model.currentEphemeris);
            this.groundStations(model.groundStations);
            this.noradSatelliteID(model.noradSatelliteID);
            this.satelliteArn(model.satelliteArn);
            this.satelliteId(model.satelliteId);
        }

        public final EphemerisMetaData.Builder getCurrentEphemeris() {
            return this.currentEphemeris != null ? this.currentEphemeris.toBuilder() : null;
        }

        public final void setCurrentEphemeris(EphemerisMetaData.BuilderImpl currentEphemeris) {
            this.currentEphemeris = currentEphemeris != null ? currentEphemeris.build() : null;
        }

        @Override
        public final Builder currentEphemeris(EphemerisMetaData currentEphemeris) {
            this.currentEphemeris = currentEphemeris;
            return this;
        }

        public final Collection<String> getGroundStations() {
            if (this.groundStations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groundStations;
        }

        public final void setGroundStations(Collection<String> groundStations) {
            this.groundStations = GroundStationIdListCopier.copy(groundStations);
        }

        @Override
        public final Builder groundStations(Collection<String> groundStations) {
            this.groundStations = GroundStationIdListCopier.copy(groundStations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groundStations(String ... groundStations) {
            this.groundStations(Arrays.asList(groundStations));
            return this;
        }

        public final Integer getNoradSatelliteID() {
            return this.noradSatelliteID;
        }

        public final void setNoradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
        }

        @Override
        public final Builder noradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
            return this;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final String getSatelliteId() {
            return this.satelliteId;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        @Override
        public GetSatelliteResponse build() {
            return new GetSatelliteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSatelliteResponse> {
        public Builder currentEphemeris(EphemerisMetaData var1);

        default public Builder currentEphemeris(Consumer<EphemerisMetaData.Builder> currentEphemeris) {
            return this.currentEphemeris((EphemerisMetaData)((EphemerisMetaData.Builder)EphemerisMetaData.builder().applyMutation(currentEphemeris)).build());
        }

        public Builder groundStations(Collection<String> var1);

        public Builder groundStations(String ... var1);

        public Builder noradSatelliteID(Integer var1);

        public Builder satelliteArn(String var1);

        public Builder satelliteId(String var1);
    }
}

