/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.Deployment;
import software.amazon.awssdk.services.greengrassv2.model.DeploymentListCopier;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentsResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, ListDeploymentsResponse> {
    private static final SdkField<List<Deployment>> DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deployments").getter(ListDeploymentsResponse.getter(ListDeploymentsResponse::deployments)).setter(ListDeploymentsResponse.setter(Builder::deployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Deployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDeploymentsResponse.getter(ListDeploymentsResponse::nextToken)).setter(ListDeploymentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDeploymentsResponse.memberNameToFieldInitializer();
    private final List<Deployment> deployments;
    private final String nextToken;

    private ListDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deployments = builder.deployments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeployments() {
        return this.deployments != null && !(this.deployments instanceof SdkAutoConstructList);
    }

    public final List<Deployment> deployments() {
        return this.deployments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeployments() ? this.deployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsResponse)) {
            return false;
        }
        ListDeploymentsResponse other = (ListDeploymentsResponse)((Object)obj);
        return this.hasDeployments() == other.hasDeployments() && Objects.equals(this.deployments(), other.deployments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeploymentsResponse").add("Deployments", this.hasDeployments() ? this.deployments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deployments": {
                return Optional.ofNullable(clazz.cast(this.deployments()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deployments", DEPLOYMENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentsResponse, T> g) {
        return obj -> g.apply((ListDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private List<Deployment> deployments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsResponse model) {
            super(model);
            this.deployments(model.deployments);
            this.nextToken(model.nextToken);
        }

        public final List<Deployment.Builder> getDeployments() {
            List<Deployment.Builder> result = DeploymentListCopier.copyToBuilder(this.deployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeployments(Collection<Deployment.BuilderImpl> deployments) {
            this.deployments = DeploymentListCopier.copyFromBuilder(deployments);
        }

        @Override
        public final Builder deployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentListCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Deployment ... deployments) {
            this.deployments(Arrays.asList(deployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Consumer<Deployment.Builder> ... deployments) {
            this.deployments(Stream.of(deployments).map(c -> (Deployment)((Deployment.Builder)Deployment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeploymentsResponse build() {
            return new ListDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeploymentsResponse> {
        public Builder deployments(Collection<Deployment> var1);

        public Builder deployments(Deployment ... var1);

        public Builder deployments(Consumer<Deployment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

