/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentFailureHandlingPolicy {
    ROLLBACK("ROLLBACK"),
    DO_NOTHING("DO_NOTHING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentFailureHandlingPolicy> VALUE_MAP;
    private final String value;

    private DeploymentFailureHandlingPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentFailureHandlingPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentFailureHandlingPolicy> knownValues() {
        EnumSet<DeploymentFailureHandlingPolicy> knownValues = EnumSet.allOf(DeploymentFailureHandlingPolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentFailureHandlingPolicy.class, DeploymentFailureHandlingPolicy::toString);
    }
}

