/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BulkDeploymentStatus {
    INITIALIZING("Initializing"),
    RUNNING("Running"),
    COMPLETED("Completed"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BulkDeploymentStatus> VALUE_MAP;
    private final String value;

    private BulkDeploymentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BulkDeploymentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BulkDeploymentStatus> knownValues() {
        EnumSet<BulkDeploymentStatus> knownValues = EnumSet.allOf(BulkDeploymentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BulkDeploymentStatus.class, BulkDeploymentStatus::toString);
    }
}

