/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BulkDeploymentMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BulkDeploymentMetrics> {
    private static final SdkField<Integer> INVALID_INPUT_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InvalidInputRecords").getter(BulkDeploymentMetrics.getter(BulkDeploymentMetrics::invalidInputRecords)).setter(BulkDeploymentMetrics.setter(Builder::invalidInputRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidInputRecords").build()}).build();
    private static final SdkField<Integer> RECORDS_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RecordsProcessed").getter(BulkDeploymentMetrics.getter(BulkDeploymentMetrics::recordsProcessed)).setter(BulkDeploymentMetrics.setter(Builder::recordsProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsProcessed").build()}).build();
    private static final SdkField<Integer> RETRY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetryAttempts").getter(BulkDeploymentMetrics.getter(BulkDeploymentMetrics::retryAttempts)).setter(BulkDeploymentMetrics.setter(Builder::retryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAttempts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_INPUT_RECORDS_FIELD, RECORDS_PROCESSED_FIELD, RETRY_ATTEMPTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BulkDeploymentMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer invalidInputRecords;
    private final Integer recordsProcessed;
    private final Integer retryAttempts;

    private BulkDeploymentMetrics(BuilderImpl builder) {
        this.invalidInputRecords = builder.invalidInputRecords;
        this.recordsProcessed = builder.recordsProcessed;
        this.retryAttempts = builder.retryAttempts;
    }

    public final Integer invalidInputRecords() {
        return this.invalidInputRecords;
    }

    public final Integer recordsProcessed() {
        return this.recordsProcessed;
    }

    public final Integer retryAttempts() {
        return this.retryAttempts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidInputRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryAttempts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkDeploymentMetrics)) {
            return false;
        }
        BulkDeploymentMetrics other = (BulkDeploymentMetrics)obj;
        return Objects.equals(this.invalidInputRecords(), other.invalidInputRecords()) && Objects.equals(this.recordsProcessed(), other.recordsProcessed()) && Objects.equals(this.retryAttempts(), other.retryAttempts());
    }

    public final String toString() {
        return ToString.builder((String)"BulkDeploymentMetrics").add("InvalidInputRecords", (Object)this.invalidInputRecords()).add("RecordsProcessed", (Object)this.recordsProcessed()).add("RetryAttempts", (Object)this.retryAttempts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvalidInputRecords": {
                return Optional.ofNullable(clazz.cast(this.invalidInputRecords()));
            }
            case "RecordsProcessed": {
                return Optional.ofNullable(clazz.cast(this.recordsProcessed()));
            }
            case "RetryAttempts": {
                return Optional.ofNullable(clazz.cast(this.retryAttempts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("InvalidInputRecords", INVALID_INPUT_RECORDS_FIELD);
        map.put("RecordsProcessed", RECORDS_PROCESSED_FIELD);
        map.put("RetryAttempts", RETRY_ATTEMPTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BulkDeploymentMetrics, T> g) {
        return obj -> g.apply((BulkDeploymentMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer invalidInputRecords;
        private Integer recordsProcessed;
        private Integer retryAttempts;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkDeploymentMetrics model) {
            this.invalidInputRecords(model.invalidInputRecords);
            this.recordsProcessed(model.recordsProcessed);
            this.retryAttempts(model.retryAttempts);
        }

        public final Integer getInvalidInputRecords() {
            return this.invalidInputRecords;
        }

        public final void setInvalidInputRecords(Integer invalidInputRecords) {
            this.invalidInputRecords = invalidInputRecords;
        }

        @Override
        public final Builder invalidInputRecords(Integer invalidInputRecords) {
            this.invalidInputRecords = invalidInputRecords;
            return this;
        }

        public final Integer getRecordsProcessed() {
            return this.recordsProcessed;
        }

        public final void setRecordsProcessed(Integer recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
        }

        @Override
        public final Builder recordsProcessed(Integer recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
            return this;
        }

        public final Integer getRetryAttempts() {
            return this.retryAttempts;
        }

        public final void setRetryAttempts(Integer retryAttempts) {
            this.retryAttempts = retryAttempts;
        }

        @Override
        public final Builder retryAttempts(Integer retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public BulkDeploymentMetrics build() {
            return new BulkDeploymentMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BulkDeploymentMetrics> {
        public Builder invalidInputRecords(Integer var1);

        public Builder recordsProcessed(Integer var1);

        public Builder retryAttempts(Integer var1);
    }
}

