/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateTargetsOperatingSystem {
    UBUNTU("ubuntu"),
    RASPBIAN("raspbian"),
    AMAZON_LINUX("amazon_linux"),
    OPENWRT("openwrt"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateTargetsOperatingSystem> VALUE_MAP;
    private final String value;

    private UpdateTargetsOperatingSystem(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateTargetsOperatingSystem fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateTargetsOperatingSystem> knownValues() {
        EnumSet<UpdateTargetsOperatingSystem> knownValues = EnumSet.allOf(UpdateTargetsOperatingSystem.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateTargetsOperatingSystem.class, UpdateTargetsOperatingSystem::toString);
    }
}

